package de.yamayaki.cesium.mixin.core.chunks;

import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.accessor.DatabaseSource;
import de.yamayaki.cesium.api.database.IDBInstance;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.concurrent.Executor;

@Mixin(class_3218.class)
public class MixinServerLevel implements DatabaseSource {
    @Unique
    private IDBInstance database;

    @Inject(
            method = "<init>",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/MinecraftServer;getFixerUpper()Lcom/mojang/datafixers/DataFixer;",
                    shift = At.Shift.AFTER
            )
    )
    public void initCesiumChunkStorage(MinecraftServer minecraftServer, Executor executor, class_32.class_5143 levelStorageAccess, class_5268 serverLevelData, class_5321 resourceKey, class_5363 levelStem, class_3949 chunkProgressListener, boolean bl, long l, List list, boolean bl2, class_8565 randomSequences, CallbackInfo ci) {
        this.database = CesiumMod.openWorldDB(levelStorageAccess.method_27424(resourceKey));
    }

    @Inject(method = "close", at = @At("RETURN"))
    private void postClose(CallbackInfo ci) {
        this.database.close();
    }

    @Override
    public IDBInstance cesium$getStorage() {
        return this.database;
    }
}
