package de.yamayaki.cesium.mixin.core.players;

import com.llamalad7.mixinextras.sugar.Local;
import de.yamayaki.cesium.api.accessor.DatabaseSetter;
import de.yamayaki.cesium.api.database.IDBInstance;
import de.yamayaki.cesium.common.spec.PlayerDatabaseSpecs;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_29;

@Mixin(class_29.class)
public class MixinPlayerDataStorage implements DatabaseSetter {
    @Unique
    private IDBInstance database;

    @Redirect(
            method = "<init>",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/io/File;mkdirs()Z"
            )
    )
    private boolean disableMkdirs(File file) {
        return true;
    }

    @Override
    public void cesium$setStorage(IDBInstance storage) {
        this.database = storage;
    }

    @Redirect(
            method = "load(Lnet/minecraft/world/entity/player/Player;Ljava/lang/String;)Ljava/util/Optional;",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/io/File;exists()Z"
            )
    )
    public boolean redirectFileExists(File instance) {
        return true;
    }

    @Redirect(
            method = "load(Lnet/minecraft/world/entity/player/Player;Ljava/lang/String;)Ljava/util/Optional;",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/io/File;isFile()Z"
            )
    )
    public boolean redirectFileIsFile(File instance) {
        return true;
    }

    @Redirect(
            method = "load(Lnet/minecraft/world/entity/player/Player;Ljava/lang/String;)Ljava/util/Optional;",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/nbt/NbtIo;readCompressed(Ljava/nio/file/Path;Lnet/minecraft/nbt/NbtAccounter;)Lnet/minecraft/nbt/CompoundTag;"
            )
    )
    public class_2487 redirectPlayerLoad(Path path, class_2505 nbtAccounter, @Local(argsOnly = true) class_1657 player) {
        return this.database
                .getDatabase(PlayerDatabaseSpecs.PLAYER_DATA)
                .getValue(player.method_5667());
    }

    @Redirect(
            method = "save",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/nio/file/Files;createTempFile(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;"
            )
    )
    public Path disableFileCreation(Path path, String a, String b, FileAttribute[] fileAttributes) {
        return null;
    }

    @Redirect(
            method = "save",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/nbt/NbtIo;writeCompressed(Lnet/minecraft/nbt/CompoundTag;Ljava/nio/file/Path;)V"
            )
    )
    public void redirectWrite(class_2487 compoundTag, Path path, @Local(argsOnly = true) class_1657 player) {
        this.database
                .getTransaction(PlayerDatabaseSpecs.PLAYER_DATA)
                .add(player.method_5667(), compoundTag);
    }

    @Redirect(
            method = "save",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/Util;safeReplaceFile(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V"
            )
    )
    public void disableFileMove(Path path, Path path2, Path path3) {
        // Do nothing
    }
}
