package de.yamayaki.cesium.mixin.core.players;

import com.llamalad7.mixinextras.sugar.Local;
import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.accessor.DatabaseSetter;
import de.yamayaki.cesium.api.accessor.DatabaseSource;
import de.yamayaki.cesium.api.database.IDBInstance;
import net.minecraft.class_1657;
import net.minecraft.class_29;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3442;
import net.minecraft.class_5218;
import net.minecraft.class_7780;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.nio.file.Path;

@Mixin(class_3324.class)
public class MixinPlayerList implements DatabaseSource {
    @Shadow
    @Final
    private class_29 playerIo;

    @Unique
    private IDBInstance database;

    @Inject(method = "<init>", at = @At("RETURN"))
    private void initCesiumPlayers(MinecraftServer minecraftServer, class_7780<?> layeredRegistryAccess, class_29 playerDataStorage, int i, CallbackInfo ci) {
        final Path path = minecraftServer.method_27050(class_5218.field_24180).getParent();

        this.database = CesiumMod.openPlayerDB(path);

        ((DatabaseSetter) this.playerIo)
                .cesium$setStorage(this.database);
    }

    @Inject(
            method = "getPlayerAdvancements",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;",
                    shift = At.Shift.BEFORE
            )
    )
    private void setAdvancementsStorage(class_3222 serverPlayer, CallbackInfoReturnable<class_2985> cir, @Local class_2985 playerAdvancements) {
        ((DatabaseSetter) playerAdvancements).cesium$setStorage(this.database);
    }

    @Inject(
            method = "getPlayerStats",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;",
                    shift = At.Shift.BEFORE
            )
    )
    private void setStatsStorage(class_1657 player, CallbackInfoReturnable<class_3442> cir, @Local class_3442 serverStatsCounter) {
        ((DatabaseSetter) serverStatsCounter).cesium$setStorage(this.database);
    }

    @Override
    public IDBInstance cesium$getStorage() {
        return this.database;
    }
}
