package de.yamayaki.cesium.mixin.debug;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_1923;
import net.minecraft.class_2507;
import net.minecraft.class_4698;

@Mixin(class_4698.class)
public class ChunkExporterMixin {
    @Unique
    private static final Path basePath = Path.of("./exportedChunks/");

    static {
        try {
            if (!Files.isDirectory(basePath)) {
                Files.createDirectories(basePath);
            }
        } catch (IOException e) {
            throw new IllegalStateException("This should not have happened");
        }
    }

    @Inject(method = "runStore", at = @At("HEAD"))
    public void storeChunkOnDisk(class_1923 chunkPos, class_4698.class_4699 pendingStore, CallbackInfo ci) {
        try {
            if (pendingStore.field_21503 == null || !pendingStore.field_21503.method_10545("Status")) {
                return;
            }

            class_2507.method_10630(pendingStore.field_21503, basePath.resolve(chunkPos.method_8324() + ".nbt"));
        } catch (IOException ignored) {
        }
    }
}
