package de.yamayaki.cesium.mixin.gui;

import com.llamalad7.mixinextras.sugar.Local;
import de.yamayaki.cesium.CesiumMod;
import de.yamayaki.cesium.api.accessor.DatabaseSource;
import de.yamayaki.cesium.api.database.IDBInstance;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_340;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.lmdbjava.Stat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;

@Mixin(class_340.class)
public class MixinDebugScreenOverlay {
    @Inject(method = "getSystemInformation", at = @At("RETURN"))
    private void cesium$addDebugInfo(CallbackInfoReturnable<List<String>> cir, @Local List<String> list) {
        if (!CesiumMod.config().showDebugInfo()) {
            return;
        }

        final MinecraftServer minecraftServer = class_310.method_1551().method_1576();
        if (minecraftServer == null || class_310.method_1551().field_1687 == null) {
            return;
        }

        final class_5321<class_1937> playerLevel = class_310
                .method_1551().field_1687
                .method_27983();

        final class_3218 serverLevel = minecraftServer.method_3847(playerLevel);

        if (serverLevel == null) {
            return;
        }

        final IDBInstance dbInstance = ((DatabaseSource) serverLevel)
                .cesium$getStorage();
        final List<Stat> stats = dbInstance.getStats();

        final int ms_depth = stats.stream().mapToInt(es -> es.depth).max().orElse(0);
        final long ms_branch_pages = stats.stream().mapToLong(es -> es.branchPages).sum();
        final long ms_leaf_pages = stats.stream().mapToLong(es -> es.leafPages).sum();
        final long ms_entries = stats.stream().mapToLong(es -> es.entries).sum();

        list.add("");
        list.add("Cesium level stats");

        list.add("ms_depth: " + ms_depth);
        list.add("ms_branch_pages: " + ms_branch_pages);
        list.add("ms_leaf_pages: " + ms_leaf_pages);
        list.add("ms_entries: " + ms_entries);
    }

}
