/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ignition.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class FlammabilityUtil {
    public static boolean hasFlammableNeighbours(LevelReader reader, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!FlammabilityUtil.isFlammable(reader, pos.relative(direction), direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFlammable(LevelReader reader, BlockPos pos, Direction face) {
        return (reader.isInsideBuildHeight(pos.getY()) || reader.hasChunkAt(pos)) && reader.getBlockState(pos).isFlammable((BlockGetter)reader, pos, face);
    }

    public static void onFireTick(BlockState state, Level level, BlockPos pos, RandomSource random, BlockState fireState) {
        block7: {
            ServerLevel serverLevel;
            if (!(level instanceof ServerLevel) || !(serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!level.isLoaded(blockpos = blockpos.offset(random.nextInt(3) - 1, random.nextInt(2), random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState blockstate = level.getBlockState(blockpos);
                    if (blockstate.isAir() && fireState.canSurvive((LevelReader)level, blockpos)) {
                        if (!FlammabilityUtil.hasFlammableNeighbours((LevelReader)level, blockpos)) continue;
                        level.setBlockAndUpdate(blockpos, fireState);
                        return;
                    }
                    if (!blockstate.blocksMotion()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos offsetPos = pos.offset(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!level.isLoaded(offsetPos)) {
                        return;
                    }
                    if (!level.isEmptyBlock(offsetPos.above()) || !FlammabilityUtil.isFlammable((LevelReader)level, offsetPos, Direction.UP) || !fireState.canSurvive((LevelReader)level, offsetPos)) continue;
                    level.setBlockAndUpdate(offsetPos.above(), fireState);
                }
            }
        }
    }
}

