/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ignition.mixin;

import com.mrbysco.ignition.config.IgnitionConfig;
import com.mrbysco.ignition.util.FlammabilityUtil;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CampfireBlockEntity.class})
public class CampfireBlockEntityMixin {
    @Inject(method={"cookTick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/CampfireBlockEntity;)V"}, at={@At(value="HEAD")})
    private static void ignitionCampfireTick(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity, CallbackInfo ci) {
        if (((Boolean)IgnitionConfig.COMMON.enableCampfire.get()).booleanValue() && state.is(Blocks.CAMPFIRE)) {
            if (level.getGameTime() % (long)CampfireBlockEntityMixin.ignition$getCampfireTickDelay(level.random, () -> ((ModConfigSpec.IntValue)IgnitionConfig.COMMON.campfireTickDelay).get()) == 0L) {
                FlammabilityUtil.onFireTick(state, level, pos, level.random, Blocks.FIRE.defaultBlockState());
            }
        } else if (((Boolean)IgnitionConfig.COMMON.enableSoulCampfire.get()).booleanValue() && state.is(Blocks.SOUL_CAMPFIRE)) {
            if (level.getGameTime() % (long)CampfireBlockEntityMixin.ignition$getCampfireTickDelay(level.random, () -> ((ModConfigSpec.IntValue)IgnitionConfig.COMMON.soulCampfireTickDelay).get()) == 0L) {
                FlammabilityUtil.onFireTick(state, level, pos, level.random, Blocks.SOUL_FIRE.defaultBlockState());
            }
        }
    }

    @Unique
    private static int ignition$getCampfireTickDelay(RandomSource rand, IntSupplier tickDelay) {
        return tickDelay.getAsInt() + rand.nextInt(10);
    }
}

