/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.ignition.mixin;

import com.mrbysco.ignition.blocks.Inferno;
import com.mrbysco.ignition.config.IgnitionConfig;
import com.mrbysco.ignition.mixin.BlockBehaviorAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={WallTorchBlock.class})
public class WallTorchBlockMixin
extends Block
implements Inferno {
    public WallTorchBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public boolean ignition$enableFire(BlockState state) {
        if (state.is(Blocks.SOUL_WALL_TORCH)) {
            return (Boolean)IgnitionConfig.COMMON.enableSoulTorch.get();
        }
        return (Boolean)IgnitionConfig.COMMON.enableTorch.get();
    }

    @Override
    public boolean ignition$randomlyTicksFire(BlockState state) {
        if (state.is(Blocks.SOUL_WALL_TORCH)) {
            return (Boolean)IgnitionConfig.COMMON.randomSoulTicking.get();
        }
        return (Boolean)IgnitionConfig.COMMON.randomTicking.get();
    }

    @Override
    public BlockState ignition$getFireState(BlockState state) {
        if (state.is(Blocks.SOUL_WALL_TORCH)) {
            return Blocks.SOUL_FIRE.defaultBlockState();
        }
        return Blocks.FIRE.defaultBlockState();
    }

    @Override
    public int ignition$getFireTickDelay(BlockState state, RandomSource rand) {
        int tickDelay = state.is(Blocks.SOUL_WALL_TORCH) ? ((Integer)IgnitionConfig.COMMON.soulCampfireTickDelay.get()).intValue() : ((Integer)IgnitionConfig.COMMON.torchTickDelay.get()).intValue();
        return tickDelay + rand.nextInt(10);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.ignition$enableFire(state)) {
            this.ignition$scheduleFireTick((Level)level, pos, state);
            this.ignition$fireTick(state, level, pos, random);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (this.ignition$enableFire(state)) {
            if (!this.isRandomlyTicking && this.ignition$randomlyTicksFire(state)) {
                ((BlockBehaviorAccessor)state.getBlock()).setIsRandomlyTicking(true);
            }
            this.ignition$scheduleFireTick(level, pos, state);
        }
    }
}

