/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltrynek.client.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import pl.lordtricker.ltrynek.client.config.PriceEntry;
import pl.lordtricker.ltrynek.client.util.CompositeKeyUtil;

@Environment(value=EnvType.CLIENT)
public class ClientPriceListManager {
    private static final Map<String, List<PriceEntry>> priceLists = new HashMap<String, List<PriceEntry>>();
    private static final Map<String, Map<String, String>> customLookup = new HashMap<String, Map<String, String>>();
    private static String activeProfile = "default";

    public static void setActiveProfile(String profile) {
        activeProfile = profile;
        priceLists.computeIfAbsent(profile, k -> new ArrayList());
        customLookup.computeIfAbsent(profile, k -> new HashMap());
    }

    public static String getActiveProfile() {
        return activeProfile;
    }

    public static String listProfiles() {
        if (priceLists.isEmpty()) {
            return "No profiles defined.";
        }
        return String.join((CharSequence)", ", priceLists.keySet());
    }

    public static void addPriceEntry(PriceEntry entry) {
        String compositeKey = CompositeKeyUtil.getCompositeKeyFromEntry(entry);
        List entries = priceLists.computeIfAbsent(activeProfile, k -> new ArrayList());
        entries.removeIf(pe -> {
            String keyFromEntry = CompositeKeyUtil.getCompositeKeyFromEntry(pe);
            return keyFromEntry.equals(compositeKey);
        });
        entries.add(entry);
    }

    public static void addPriceEntry(String rawItem, double maxPrice) {
        String compositeKey = CompositeKeyUtil.createCompositeKey(rawItem);
        String[] parts = compositeKey.split("\\|", -1);
        if (parts.length < 3) {
            return;
        }
        PriceEntry newEntry = new PriceEntry();
        newEntry.name = parts[0];
        newEntry.lore = parts[1];
        newEntry.material = parts[2];
        newEntry.enchants = parts.length > 3 ? parts[3] : "";
        newEntry.maxPrice = maxPrice;
        ClientPriceListManager.addPriceEntry(newEntry);
    }

    public static void removePriceEntry(String rawItem) {
        String compositeKey = CompositeKeyUtil.createCompositeKey(rawItem);
        List<PriceEntry> entries = priceLists.get(activeProfile);
        if (entries != null) {
            entries.removeIf(pe -> {
                String keyFromEntry = (pe.name + "|" + (pe.lore == null ? "" : pe.lore) + "|" + (pe.material == null ? "" : pe.material) + "|" + (pe.enchants == null ? "" : pe.enchants)).toLowerCase();
                return keyFromEntry.equals(compositeKey);
            });
        }
    }

    public static PriceEntry findMatchingPriceEntry(String noColorName, List<String> loreLines, String materialId, String enchantments) {
        List<PriceEntry> entries = priceLists.get(activeProfile);
        if (entries == null) {
            return null;
        }
        for (PriceEntry pe : entries) {
            if (pe.material != null && !pe.material.isEmpty() && !materialId.equalsIgnoreCase(pe.material)) continue;
            if (!pe.name.isEmpty()) {
                String lowerName = noColorName.toLowerCase();
                String lowerMaterial = materialId.toLowerCase();
                String lowerEntryName = pe.name.toLowerCase();
                if (!lowerName.contains(lowerEntryName) && !lowerMaterial.contains(lowerEntryName)) continue;
            }
            if (pe.lore != null && !pe.lore.isEmpty()) {
                boolean foundLore = false;
                for (String line : loreLines) {
                    if (!line.toLowerCase().contains(pe.lore.toLowerCase())) continue;
                    foundLore = true;
                    break;
                }
                if (!foundLore) continue;
            }
            if (pe.enchants != null && !pe.enchants.isEmpty() && (enchantments == null || enchantments.isEmpty() || !enchantments.toLowerCase().contains(pe.enchants.toLowerCase()))) continue;
            return pe;
        }
        return null;
    }

    public static Map<String, List<PriceEntry>> getAllProfiles() {
        return priceLists;
    }

    public static void clearAllProfiles() {
        priceLists.clear();
        customLookup.clear();
        activeProfile = "default";
    }
}

