/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltrynek.client.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import pl.lordtricker.ltrynek.client.LtrynekClient;
import pl.lordtricker.ltrynek.client.config.ConfigLoader;
import pl.lordtricker.ltrynek.client.config.PriceEntry;
import pl.lordtricker.ltrynek.client.config.ServerEntry;
import pl.lordtricker.ltrynek.client.keybinding.ToggleScanner;
import pl.lordtricker.ltrynek.client.manager.ClientPriceListManager;
import pl.lordtricker.ltrynek.client.manager.ClientSearchListManager;
import pl.lordtricker.ltrynek.client.util.ColorUtils;
import pl.lordtricker.ltrynek.client.util.CompositeKeyUtil;
import pl.lordtricker.ltrynek.client.util.Messages;
import pl.lordtricker.ltrynek.client.util.PriceFormatter;

@Environment(value=EnvType.CLIENT)
public class ClientCommandRegistration {
    public static void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register(ClientCommandRegistration::registerLtrynekCommand);
    }

    private static void registerLtrynekCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ltr").executes(ctx -> {
            String activeProfile = ClientPriceListManager.getActiveProfile();
            String message = Messages.format("mod.info", Map.of("profile", activeProfile));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(message));
            return 1;
        })).then(ClientCommandManager.literal((String)"scan").executes(ctx -> {
            ToggleScanner.scanningEnabled = !ToggleScanner.scanningEnabled;
            String msgKey = ToggleScanner.scanningEnabled ? "command.scanner.toggle.on" : "command.scanner.toggle.off";
            String msg = Messages.get(msgKey);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        }))).then(ClientCommandManager.literal((String)"profiles").executes(ctx -> {
            String allProfiles = ClientPriceListManager.listProfiles();
            String[] profiles = allProfiles.split(",\\s*");
            String headerStr = Messages.get("command.profiles.header");
            class_5250 finalText = (class_5250)ColorUtils.translateColorCodes(headerStr);
            finalText.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            String activeProfile = ClientPriceListManager.getActiveProfile();
            for (String profile : profiles) {
                String trimmedProfile = profile.trim();
                String lineTemplate = trimmedProfile.equals(activeProfile) ? Messages.format("profile.picked.line", Map.of("profile", trimmedProfile)) : Messages.format("profile.available.line", Map.of("profile", trimmedProfile));
                class_5250 lineText = (class_5250)ColorUtils.translateColorCodes(lineTemplate);
                if (!trimmedProfile.equals(activeProfile)) {
                    class_2583 clickableStyle = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/ltr profile " + trimmedProfile)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Kliknij, aby zmieni\u0107 profil na " + trimmedProfile))));
                    lineText.method_10862(clickableStyle);
                }
                finalText.method_10852((class_2561)lineText).method_10852((class_2561)class_2561.method_43470((String)"\n"));
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)finalText);
            return 1;
        }))).then(ClientCommandManager.literal((String)"profile").then(ClientCommandManager.argument((String)"profile", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String profile = StringArgumentType.getString((CommandContext)ctx, (String)"profile");
            ClientPriceListManager.setActiveProfile(profile);
            String msg = Messages.format("command.profile.change", Map.of("profile", profile));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        })))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"maxPrice", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"itemName", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            Object remaining = builder.getRemaining().toLowerCase();
            if (((String)remaining).startsWith("mc:")) {
                remaining = "minecraft:" + ((String)remaining).substring(3);
            }
            if (((String)remaining).contains("minecraft:")) {
                Set allItemIds = class_7923.field_41178.method_10235();
                for (class_2960 itemId : allItemIds) {
                    String asString = itemId.toString();
                    if (!asString.contains((CharSequence)remaining)) continue;
                    builder.suggest(asString);
                }
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String maxPriceStr = StringArgumentType.getString((CommandContext)ctx, (String)"maxPrice");
            double parsedPrice = PriceFormatter.parsePrice(maxPriceStr);
            if (parsedPrice < 0.0) {
                ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)("Invalid price format: " + maxPriceStr)));
                return 0;
            }
            String fullItemName = StringArgumentType.getString((CommandContext)ctx, (String)"itemName");
            ClientPriceListManager.addPriceEntry(fullItemName, parsedPrice);
            String activeProfile = ClientPriceListManager.getActiveProfile();
            String friendly = CompositeKeyUtil.getFriendlyName(CompositeKeyUtil.createCompositeKey(fullItemName));
            String shortPrice = PriceFormatter.formatPrice(parsedPrice);
            String msg = Messages.format("command.add.success", Map.of("item", friendly, "price", shortPrice, "profile", activeProfile));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            ClientCommandRegistration.syncMemoryToConfig();
            return 1;
        }))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"itemName", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String rawItem = StringArgumentType.getString((CommandContext)ctx, (String)"itemName");
            String activeProfile = ClientPriceListManager.getActiveProfile();
            ClientPriceListManager.removePriceEntry(rawItem);
            String friendly = CompositeKeyUtil.getFriendlyName(CompositeKeyUtil.createCompositeKey(rawItem));
            String msg = Messages.format("command.remove.success", Map.of("item", friendly, "profile", activeProfile));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            ClientCommandRegistration.syncMemoryToConfig();
            return 1;
        })))).then(ClientCommandManager.literal((String)"list").executes(ctx -> {
            String activeProfile = ClientPriceListManager.getActiveProfile();
            List<PriceEntry> entries = ClientPriceListManager.getAllProfiles().get(activeProfile);
            class_5250 finalText = class_2561.method_43473();
            if (entries != null) {
                for (PriceEntry pe : entries) {
                    String compositeKey = CompositeKeyUtil.getCompositeKeyFromEntry(pe);
                    String friendlyName = CompositeKeyUtil.getFriendlyName(compositeKey);
                    String priceStr = PriceFormatter.formatPrice(pe.maxPrice);
                    String editIconStr = Messages.get("pricelist.icon.edit");
                    class_5250 editIcon = (class_5250)ColorUtils.translateColorCodes(editIconStr);
                    editIcon.method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11745, "/ltr add " + priceStr + " " + friendlyName)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Kliknij aby zedytowa\u0107 " + friendlyName)))));
                    String removeIconStr = Messages.get("pricelist.icon.remove");
                    class_5250 removeIcon = (class_5250)ColorUtils.translateColorCodes(removeIconStr);
                    removeIcon.method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/ltr remove " + friendlyName)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Kliknij aby usun\u0105\u0107 " + friendlyName)))));
                    String itemLineStr = Messages.format("pricelist.item_line", Map.of("item", friendlyName, "price", priceStr));
                    class_5250 itemLine = (class_5250)ColorUtils.translateColorCodes(itemLineStr);
                    class_5250 lineText = class_2561.method_43473().method_10852((class_2561)editIcon).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)removeIcon).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)itemLine).method_10852((class_2561)class_2561.method_43470((String)"\n"));
                    finalText.method_10852((class_2561)lineText);
                }
            }
            String msgHeader = Messages.format("command.list", Map.of("profile", activeProfile, "list", ""));
            class_5250 header = (class_5250)ColorUtils.translateColorCodes(msgHeader);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)header);
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)finalText);
            return 1;
        }))).then(ClientCommandManager.literal((String)"pomoc").executes(ctx -> {
            String msg = Messages.get("command.help");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"config").then(ClientCommandManager.literal((String)"save").executes(ctx -> {
            ClientCommandRegistration.syncMemoryToConfig();
            ConfigLoader.saveAllConfigs(LtrynekClient.serversConfig);
            String msg = Messages.get("command.config.save.success");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        }))).then(ClientCommandManager.literal((String)"reload").executes(ctx -> {
            LtrynekClient.serversConfig = ConfigLoader.loadConfig();
            ClientPriceListManager.clearAllProfiles();
            ClientCommandRegistration.reinitProfilesFromConfig();
            String msg = Messages.get("command.config.reload.success");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sounds").executes(ctx -> {
            boolean current = LtrynekClient.serversConfig.soundsEnabled;
            String msg = current ? Messages.get("command.sounds.current_on") : Messages.get("command.sounds.current_off");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        })).then(ClientCommandManager.literal((String)"on").executes(ctx -> {
            LtrynekClient.serversConfig.soundsEnabled = true;
            String msg = Messages.get("command.sounds.enabled");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            ConfigLoader.saveAllConfigs(LtrynekClient.serversConfig);
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(ctx -> {
            LtrynekClient.serversConfig.soundsEnabled = false;
            String msg = Messages.get("command.sounds.disabled");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            ConfigLoader.saveAllConfigs(LtrynekClient.serversConfig);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"search").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            Object remaining = builder.getRemaining().toLowerCase();
            if (((String)remaining).startsWith("mc:")) {
                remaining = "minecraft:" + ((String)remaining).substring(3);
            }
            if (((String)remaining).contains("minecraft:")) {
                Set allItemIds = class_7923.field_41178.method_10235();
                for (class_2960 itemId : allItemIds) {
                    String asString = itemId.toString();
                    if (!asString.contains((CharSequence)remaining)) continue;
                    builder.suggest(asString);
                }
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String rawItem = StringArgumentType.getString((CommandContext)ctx, (String)"item");
            ClientSearchListManager.addItem(rawItem);
            String msg = Messages.format("command.searchlist.add", Map.of("item", rawItem));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        })))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String rawItem = StringArgumentType.getString((CommandContext)ctx, (String)"item");
            ClientSearchListManager.removeItem(rawItem);
            String friendly = CompositeKeyUtil.getFriendlyName(CompositeKeyUtil.createCompositeKey(rawItem));
            String msg = Messages.format("command.searchlist.remove", Map.of("item", friendly));
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        })))).then(ClientCommandManager.literal((String)"start").executes(ctx -> {
            ClientSearchListManager.startSearch();
            String msg = Messages.get("command.searchlist.start");
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(msg));
            return 1;
        }))).then(ClientCommandManager.literal((String)"stop").executes(ctx -> {
            ClientSearchListManager.stopSearch();
            List<String> searchItems = ClientSearchListManager.getSearchList();
            if (searchItems.isEmpty()) {
                String emptyMsg = Messages.get("command.searchlist.list.empty");
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(emptyMsg));
                return 1;
            }
            class_5250 finalText = class_2561.method_43473();
            String headerRaw = Messages.get("command.searchlist.stop.header");
            finalText.method_10852(ColorUtils.translateColorCodes(headerRaw)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
            for (String compositeKey : searchItems) {
                ClientSearchListManager.Stats stats = ClientSearchListManager.getStats(compositeKey);
                if (stats == null || stats.getCount() == 0) continue;
                String lineRaw = Messages.format("command.searchlist.stop.line", Map.of("item", CompositeKeyUtil.getFriendlyName(compositeKey), "count", String.valueOf(stats.getCount()), "min", PriceFormatter.formatPrice(stats.getMin()), "max", PriceFormatter.formatPrice(stats.getMax()), "avg", PriceFormatter.formatPrice(stats.getAverage()), "median", PriceFormatter.formatPrice(stats.getMedian()), "quartile1", PriceFormatter.formatPrice(stats.getQuartile1()), "quartile3", PriceFormatter.formatPrice(stats.getQuartile3())));
                finalText.method_10852(ColorUtils.translateColorCodes(lineRaw)).method_10852((class_2561)class_2561.method_43470((String)"\n"));
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)finalText);
            return 1;
        }))).then(ClientCommandManager.literal((String)"list").executes(ctx -> {
            List<String> searchItems = ClientSearchListManager.getSearchList();
            if (searchItems.isEmpty()) {
                String emptyMsg = Messages.get("command.searchlist.list.empty");
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback(ColorUtils.translateColorCodes(emptyMsg));
                return 1;
            }
            String header = Messages.get("command.searchlist.list.header");
            class_5250 finalText = (class_5250)ColorUtils.translateColorCodes(header);
            finalText.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            for (String compositeKey : searchItems) {
                String friendly = CompositeKeyUtil.getFriendlyName(compositeKey);
                class_5250 friendlyText = class_2561.method_43470((String)friendly);
                String removeIconStr = Messages.get("pricelist.icon.remove");
                class_5250 removeIcon = (class_5250)ColorUtils.translateColorCodes(removeIconStr);
                removeIcon.method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/ltr search remove " + friendly)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)Messages.get("command.searchlist.list.remove.hover")))));
                class_5250 lineText = class_2561.method_43473().method_10852((class_2561)removeIcon).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)friendlyText);
                finalText.method_10852((class_2561)lineText).method_10852((class_2561)class_2561.method_43470((String)"\n"));
            }
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)finalText);
            return 1;
        }))));
    }

    private static void syncMemoryToConfig() {
        if (LtrynekClient.serversConfig == null || LtrynekClient.serversConfig.servers == null) {
            return;
        }
        Map<String, List<PriceEntry>> allProfiles = ClientPriceListManager.getAllProfiles();
        for (ServerEntry se : LtrynekClient.serversConfig.servers) {
            List memList = allProfiles.getOrDefault(se.profileName, List.of());
            se.prices.clear();
            for (PriceEntry src : memList) {
                PriceEntry pe = new PriceEntry();
                pe.name = src.name;
                pe.maxPrice = src.maxPrice;
                pe.lore = src.lore;
                pe.material = src.material;
                pe.enchants = src.enchants;
                se.prices.add(pe);
            }
        }
        ConfigLoader.saveAllConfigs(LtrynekClient.serversConfig);
    }

    private static void reinitProfilesFromConfig() {
        for (ServerEntry entry : LtrynekClient.serversConfig.servers) {
            ClientPriceListManager.setActiveProfile(entry.profileName);
            for (PriceEntry pe : entry.prices) {
                Object rawItem = pe.name;
                if (pe.lore != null && !pe.lore.isEmpty()) {
                    rawItem = (String)rawItem + "(\"" + pe.lore + "\")";
                }
                if (pe.material != null && !pe.material.isEmpty()) {
                    rawItem = (String)rawItem + "[\"" + pe.material + "\"]";
                }
                if (pe.enchants != null && !pe.enchants.isEmpty()) {
                    rawItem = (String)rawItem + "{\"" + pe.enchants + "\"}";
                }
                ClientPriceListManager.addPriceEntry((String)rawItem, pe.maxPrice);
            }
        }
        String address = LtrynekClient.getServerAddress();
        ServerEntry serverEntry = ClientCommandRegistration.findServerEntryByAddress(address);
        if (serverEntry != null) {
            ClientPriceListManager.setActiveProfile(serverEntry.profileName);
        } else {
            ClientPriceListManager.setActiveProfile(LtrynekClient.serversConfig.defaultProfile);
        }
    }

    private static ServerEntry findServerEntryByAddress(String address) {
        if (LtrynekClient.serversConfig == null || LtrynekClient.serversConfig.servers == null) {
            return null;
        }
        for (ServerEntry entry : LtrynekClient.serversConfig.servers) {
            for (String domain : entry.domains) {
                if (!address.equalsIgnoreCase(domain) && !address.toLowerCase().endsWith("." + domain.toLowerCase())) continue;
                return entry;
            }
        }
        return null;
    }

    private static ServerEntry findServerEntryByProfile(String profileName) {
        if (LtrynekClient.serversConfig == null || LtrynekClient.serversConfig.servers == null) {
            return null;
        }
        for (ServerEntry entry : LtrynekClient.serversConfig.servers) {
            if (!entry.profileName.equalsIgnoreCase(profileName)) continue;
            return entry;
        }
        return null;
    }
}

