/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltrynek.client.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3936;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pl.lordtricker.ltrynek.client.LtrynekClient;
import pl.lordtricker.ltrynek.client.config.PriceEntry;
import pl.lordtricker.ltrynek.client.config.ServerEntry;
import pl.lordtricker.ltrynek.client.keybinding.ToggleScanner;
import pl.lordtricker.ltrynek.client.manager.ClientPriceListManager;
import pl.lordtricker.ltrynek.client.manager.ClientSearchListManager;
import pl.lordtricker.ltrynek.client.mixin.ScreenHandlerAccessor;
import pl.lordtricker.ltrynek.client.util.ColorStripUtils;
import pl.lordtricker.ltrynek.client.util.EnchantMapper;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class HandledScreenMixin {
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    private int lastMatchedCount = 0;
    private static final Pattern NEWER_PATTERN = Pattern.compile("ResourceKey\\[\\s*minecraft:enchantment\\s*/\\s*minecraft:([^\\]]+)\\]\\s*=Enchantment [^}]+}\\s*=>\\s*(\\d+)");
    private static final Pattern OLDER_PATTERN = Pattern.compile("\\{id:\"([^\"]+)\",lvl:(\\d+)s\\}");

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!ToggleScanner.scanningEnabled) {
            return;
        }
        class_1703 handler = ((class_3936)this).method_17577();
        class_2371<class_1735> slots = ((ScreenHandlerAccessor)handler).getSlots();
        int matchedCount = 0;
        for (class_1735 slot : slots) {
            if (!this.processSlot(context, slot)) continue;
            ++matchedCount;
        }
        if (LtrynekClient.serversConfig != null && LtrynekClient.serversConfig.soundsEnabled && matchedCount != this.lastMatchedCount && matchedCount > 0) {
            this.playAlarmSound(matchedCount);
        }
        this.lastMatchedCount = matchedCount;
    }

    private boolean processSlot(class_332 context, class_1735 slot) {
        PriceEntry matchedEntry;
        String uniqueKey;
        double finalPrice;
        String activeProfile;
        ServerEntry entry;
        String enchantmentsString;
        class_1799 stack = slot.method_7677();
        if (stack.method_7960()) {
            return false;
        }
        String displayName = stack.method_7964().getString();
        String noColorName = ColorStripUtils.stripAllColorsAndFormats(displayName);
        class_746 player = class_310.method_1551().field_1724;
        List tooltip = stack.method_7950((class_1657)player, (class_1836)class_1836.field_41070);
        ArrayList<String> loreLines = new ArrayList<String>();
        for (int i = 0; i < tooltip.size(); ++i) {
            if (i == 0) continue;
            class_2561 textLine = (class_2561)tooltip.get(i);
            String plain = textLine.getString();
            String noColorLine = ColorStripUtils.stripAllColorsAndFormats(plain);
            loreLines.add(noColorLine);
        }
        String rawEnchants = stack.method_7921().toString();
        Matcher enchantMatcherNew = NEWER_PATTERN.matcher(rawEnchants);
        StringBuilder enchantBuilder = new StringBuilder();
        boolean foundAny = false;
        while (enchantMatcherNew.find()) {
            foundAny = true;
            String enchId = enchantMatcherNew.group(1).trim();
            String levelStr = enchantMatcherNew.group(2).trim();
            String shortEnchant = enchId + levelStr;
            String mappedEnchant = EnchantMapper.mapEnchant(shortEnchant, true);
            if (!enchantBuilder.isEmpty()) {
                enchantBuilder.append(",");
            }
            enchantBuilder.append(mappedEnchant);
        }
        if (!foundAny) {
            Matcher enchantMatcherOld = OLDER_PATTERN.matcher(rawEnchants);
            while (enchantMatcherOld.find()) {
                String enchId = enchantMatcherOld.group(1).trim();
                String levelStr = enchantMatcherOld.group(2).trim();
                if (enchId.startsWith("minecraft:")) {
                    enchId = enchId.substring("minecraft:".length());
                }
                String shortEnchant = enchId + levelStr;
                String mappedEnchant = EnchantMapper.mapEnchant(shortEnchant, false);
                if (!enchantBuilder.isEmpty()) {
                    enchantBuilder.append(",");
                }
                enchantBuilder.append(mappedEnchant);
            }
        }
        if (!(enchantmentsString = enchantBuilder.toString()).isEmpty()) {
            loreLines.add(enchantmentsString);
        }
        if ((entry = this.findServerEntryByProfile(activeProfile = ClientPriceListManager.getActiveProfile())) == null) {
            return false;
        }
        String loreRegex = entry.loreRegex;
        String colorStr = entry.highlightColor;
        String colorStackStr = entry.highlightColorStack == null || entry.highlightColorStack.isEmpty() ? colorStr : entry.highlightColorStack;
        int highlightColor = this.parseColor(colorStr);
        int highlightColorStack = this.parseColor(colorStackStr);
        double foundPrice = -1.0;
        Pattern pattern = Pattern.compile(loreRegex);
        for (String plain : loreLines) {
            String priceGroup;
            double parsedPrice;
            Matcher m = pattern.matcher(plain);
            if (!m.find() || !((parsedPrice = this.parsePriceWithSuffix(priceGroup = m.group(1))) >= 0.0)) continue;
            foundPrice = parsedPrice;
            break;
        }
        if (foundPrice < 0.0) {
            return false;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        String materialId = id.toString();
        int stackSize = stack.method_7947();
        boolean isStack = stackSize > 1;
        double d = finalPrice = isStack ? foundPrice / (double)stackSize : foundPrice;
        if (ClientSearchListManager.isSearchActive() && !ClientSearchListManager.isAlreadyCounted(uniqueKey = slot.field_7874 + "|" + noColorName + "|" + finalPrice + "|" + stackSize)) {
            ClientSearchListManager.markAsCounted(uniqueKey);
            String lowerName = noColorName.toLowerCase();
            for (String compositeKey : ClientSearchListManager.getSearchList()) {
                if (!ClientSearchListManager.matchesSearchTerm(compositeKey, noColorName, loreLines, materialId, enchantmentsString)) continue;
                ClientSearchListManager.updateStats(compositeKey, finalPrice, stackSize);
            }
        }
        if ((matchedEntry = ClientPriceListManager.findMatchingPriceEntry(noColorName, loreLines, materialId, enchantmentsString)) == null) {
            return false;
        }
        double maxPrice = matchedEntry.maxPrice;
        if (finalPrice <= maxPrice) {
            double alphaF;
            double ratio = finalPrice / maxPrice;
            if (ratio > 1.0) {
                ratio = 1.0;
            }
            if ((alphaF = 1.0 - 0.75 * ratio) < 0.3) {
                alphaF = 0.3;
            }
            int computedAlpha = (int)(alphaF * 255.0) & 0xFF;
            int baseRGB = isStack ? highlightColorStack & 0xFFFFFF : highlightColor & 0xFFFFFF;
            int dynamicColor = computedAlpha << 24 | baseRGB;
            int realX = this.field_2776 + slot.field_7873;
            int realY = this.field_2800 + slot.field_7872;
            context.method_25294(realX, realY, realX + 16, realY + 16, dynamicColor);
            return true;
        }
        return false;
    }

    private void playAlarmSound(int matchedCount) {
        String activeProfile = ClientPriceListManager.getActiveProfile();
        ServerEntry entry = this.findServerEntryByProfile(activeProfile);
        if (entry == null) {
            return;
        }
        String miniSound = entry.miniAlarmSound;
        String stackSound = entry.miniAlarmSoundStack;
        if (miniSound == null) {
            miniSound = "";
        }
        if (stackSound == null) {
            stackSound = "";
        }
        if (matchedCount <= 9) {
            this.playSoundNTimes(miniSound, matchedCount);
        } else {
            this.playSoundNTimes(stackSound, 1);
        }
    }

    private void playSoundNTimes(String soundId, int times) {
        if (soundId.isEmpty() || times <= 0) {
            return;
        }
        class_2960 id = class_2960.method_12829((String)soundId);
        if (id == null) {
            return;
        }
        final class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(id);
        if (soundEvent == null) {
            return;
        }
        final Timer timer = new Timer();
        long initialDelay = 300L;
        long interval = 150L;
        for (int i = 0; i < times; ++i) {
            long delay = initialDelay + (long)i * interval;
            timer.schedule(new TimerTask(this){
                final /* synthetic */ HandledScreenMixin this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    class_310.method_1551().execute(() -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)1.0f, (float)1.0f)));
                }
            }, delay);
        }
        timer.schedule(new TimerTask(this){
            final /* synthetic */ HandledScreenMixin this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                timer.cancel();
            }
        }, initialDelay + (long)times * interval + 50L);
    }

    private double parsePriceWithSuffix(String raw) {
        int i;
        raw = ((String)raw).trim().replace(" ", "");
        String lower = ((String)raw).toLowerCase();
        double multiplier = 1.0;
        if (lower.endsWith("mld")) {
            multiplier = 1.0E9;
            raw = ((String)raw).substring(0, ((String)raw).length() - 3);
        } else if (lower.endsWith("m")) {
            multiplier = 1000000.0;
            raw = ((String)raw).substring(0, ((String)raw).length() - 1);
        } else if (lower.endsWith("k")) {
            multiplier = 1000.0;
            raw = ((String)raw).substring(0, ((String)raw).length() - 1);
        }
        if (!((String)raw).contains(".") && (i = ((String)raw).indexOf(44, ((String)raw).length() - 3)) != -1) {
            raw = ((String)raw).substring(0, i) + "." + ((String)raw).substring(i + 1);
        }
        raw = ((String)raw).replace(",", "");
        try {
            double base = Double.parseDouble((String)raw);
            return base * multiplier;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private ServerEntry findServerEntryByProfile(String profileName) {
        if (LtrynekClient.serversConfig == null || LtrynekClient.serversConfig.servers == null) {
            return null;
        }
        for (ServerEntry se : LtrynekClient.serversConfig.servers) {
            if (!se.profileName.equals(profileName)) continue;
            return se;
        }
        return null;
    }

    private int parseColor(String colorStr) {
        if (((String)colorStr).startsWith("#")) {
            colorStr = ((String)colorStr).substring(1);
        }
        if (((String)colorStr).length() == 6) {
            colorStr = "FF" + (String)colorStr;
        }
        long argb = Long.parseLong((String)colorStr, 16);
        return (int)(argb & 0xFFFFFFFFFFFFFFFFL);
    }
}

