/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltrynek.client.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import pl.lordtricker.ltrynek.client.config.PriceEntry;

@Environment(value=EnvType.CLIENT)
public class CompositeKeyUtil {
    private static final Pattern PATTERN = Pattern.compile("^(.*?)\\s*(?:\\(\\s*\\\"([^\\\"]+)\\\"\\s*\\))?\\s*(?:\\[\\s*\\\"([^\\\"]+)\\\"\\s*\\])?\\s*(?:\\{\\s*\\\"([^\\\"]+)\\\"\\s*\\})?\\s*$");

    public static String createCompositeKey(String rawInput) {
        String baseName;
        String normalized = rawInput.trim();
        if (normalized.startsWith("[\"") && normalized.endsWith("\"]")) {
            String material = normalized.substring(2, normalized.length() - 2).trim().toLowerCase();
            return material + "|||";
        }
        if (normalized.toLowerCase().startsWith("minecraft:") && normalized.matches("(?i)^minecraft:[a-z0-9_]+$")) {
            String material = normalized.toLowerCase();
            return material + "|||";
        }
        Matcher matcher = PATTERN.matcher(normalized);
        String lore = "";
        Object material = "";
        String enchants = "";
        if (matcher.matches()) {
            baseName = matcher.group(1).trim();
            if (matcher.group(2) != null) {
                lore = matcher.group(2).trim();
            }
            if (matcher.group(3) != null) {
                material = matcher.group(3).trim();
            }
            if (matcher.group(4) != null) {
                enchants = matcher.group(4).trim();
            }
        } else {
            baseName = normalized;
        }
        if (!((String)material).isEmpty() && !((String)material).toLowerCase().startsWith("minecraft:")) {
            material = "minecraft:" + (String)material;
        }
        return (baseName + "|" + lore + "|" + (String)material + "|" + enchants).toLowerCase();
    }

    public static String getFriendlyName(String compositeKey) {
        String[] parts = compositeKey.split("\\|", -1);
        String baseName = parts[0];
        String lore = parts[1];
        String material = parts[2];
        String enchants = parts.length > 3 ? parts[3] : "";
        StringBuilder sb = new StringBuilder();
        if (!baseName.isEmpty()) {
            sb.append(baseName);
            if (!lore.isEmpty()) {
                sb.append("(\"").append(lore).append("\")");
            }
            if (!material.isEmpty()) {
                sb.append("[\"").append(material).append("\"]");
            }
            if (!enchants.isEmpty()) {
                sb.append("{\"").append(enchants).append("\"}");
            }
            return sb.toString();
        }
        if (!material.isEmpty()) {
            return material;
        }
        return "";
    }

    public static String getCompositeKeyFromEntry(PriceEntry entry) {
        return (entry.name + "|" + (entry.lore == null ? "" : entry.lore) + "|" + (entry.material == null ? "" : entry.material) + "|" + (entry.enchants == null ? "" : entry.enchants)).toLowerCase();
    }

    public static String[] splitCompositeKey(String compositeKey) {
        return compositeKey.split("\\|", -1);
    }
}

