/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltrynek.client.util;

import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PriceFormatter {
    public static double parsePrice(String raw) {
        if (raw == null || raw.isEmpty()) {
            return -1.0;
        }
        raw = raw.trim().replace(',', '.');
        double multiplier = 1.0;
        String lower = raw.toLowerCase();
        if (lower.endsWith("k")) {
            multiplier = 1000.0;
            raw = raw.substring(0, raw.length() - 1);
        } else if (lower.endsWith("mld")) {
            multiplier = 1.0E9;
            raw = raw.substring(0, raw.length() - 3);
        } else if (lower.endsWith("m")) {
            multiplier = 1000000.0;
            raw = raw.substring(0, raw.length() - 1);
        }
        try {
            double base = Double.parseDouble(raw);
            return base * multiplier;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static String formatPrice(double value) {
        double absVal = Math.abs(value);
        String suffix = "";
        if (absVal >= 1.0E9) {
            value /= 1.0E9;
            suffix = "mld";
        } else if (absVal >= 1000000.0) {
            value /= 1000000.0;
            suffix = "m";
        } else if (absVal >= 1000.0) {
            value /= 1000.0;
            suffix = "k";
        }
        String formatted = String.format(Locale.US, "%.2f", value);
        if (formatted.contains(".")) {
            formatted = formatted.replaceAll("0+$", "").replaceAll("\\.$", "");
        }
        return formatted + suffix;
    }
}

