/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltrynek.client.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import pl.lordtricker.ltrynek.client.util.CompositeKeyUtil;
import pl.lordtricker.ltrynek.client.util.Messages;

@Environment(value=EnvType.CLIENT)
public class ClientSearchListManager {
    private static final List<String> searchList = new ArrayList<String>();
    private static final Map<String, Stats> statsMap = new HashMap<String, Stats>();
    private static boolean searchActive = false;
    private static Timer searchTimer = null;
    private static final Set<String> alreadyCountedSession = new HashSet<String>();

    public static void addItem(String rawItem) {
        String compositeKey = CompositeKeyUtil.createCompositeKey(rawItem);
        if (!searchList.contains(compositeKey)) {
            searchList.add(compositeKey);
            statsMap.put(compositeKey, new Stats());
        }
    }

    public static void removeItem(String rawItem) {
        String compositeKey = CompositeKeyUtil.createCompositeKey(rawItem);
        searchList.remove(compositeKey);
        statsMap.remove(compositeKey);
    }

    public static List<String> getSearchList() {
        return searchList;
    }

    public static void startSearch() {
        searchActive = true;
        for (String key : searchList) {
            statsMap.put(key, new Stats());
        }
        alreadyCountedSession.clear();
        if (searchTimer != null) {
            searchTimer.cancel();
        }
        searchTimer = new Timer();
        searchTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ClientSearchListManager.stopSearch();
                class_310.method_1551().execute(() -> {
                    if (class_310.method_1551().field_1724 != null) {
                        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43470((String)Messages.get("command.searchlist.expired")), false);
                    }
                });
            }
        }, 300000L);
    }

    public static void stopSearch() {
        searchActive = false;
        if (searchTimer != null) {
            searchTimer.cancel();
            searchTimer = null;
        }
    }

    public static boolean isSearchActive() {
        return searchActive;
    }

    public static boolean isAlreadyCounted(String key) {
        return alreadyCountedSession.contains(key);
    }

    public static void markAsCounted(String key) {
        alreadyCountedSession.add(key);
    }

    public static void updateStats(String compositeKey, double unitPrice, int quantity) {
        Stats s = statsMap.get(compositeKey);
        if (s == null) {
            s = new Stats();
            statsMap.put(compositeKey, s);
        }
        s.update(unitPrice, quantity);
    }

    public static Stats getStats(String rawItem) {
        return statsMap.get(rawItem.toLowerCase());
    }

    public static boolean matchesSearchTerm(String compositeKey, String noColorName, List<String> loreLines, String materialId, String enchantments) {
        String[] parts = CompositeKeyUtil.splitCompositeKey(compositeKey);
        String baseName = parts[0];
        String lore = parts[1];
        String material = parts[2];
        String compEnchants = parts.length > 3 ? parts[3] : "";
        String lowerName = noColorName.toLowerCase();
        String lowerMaterial = materialId.toLowerCase();
        String lowerBaseName = baseName.toLowerCase();
        boolean nameMatches = lowerName.contains(lowerBaseName) || lowerMaterial.contains(lowerBaseName);
        boolean loreMatches = true;
        if (!lore.isEmpty()) {
            loreMatches = false;
            for (String line : loreLines) {
                if (!line.toLowerCase().contains(lore.toLowerCase())) continue;
                loreMatches = true;
                break;
            }
        }
        boolean materialMatches = true;
        if (!material.isEmpty()) {
            materialMatches = materialId.equalsIgnoreCase(material);
        }
        boolean enchantMatches = true;
        if (!(compEnchants.isEmpty() || enchantments != null && !enchantments.isEmpty() && enchantments.toLowerCase().contains(compEnchants.toLowerCase()))) {
            enchantMatches = false;
        }
        return nameMatches && loreMatches && materialMatches && enchantMatches;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Stats {
        private int count = 0;
        private double sum = 0.0;
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;
        private final List<Double> values = new ArrayList<Double>();

        public void update(double unitPrice, int quantity) {
            this.count += quantity;
            this.sum += unitPrice * (double)quantity;
            if (unitPrice < this.min) {
                this.min = unitPrice;
            }
            if (unitPrice > this.max) {
                this.max = unitPrice;
            }
            for (int i = 0; i < quantity; ++i) {
                this.values.add(unitPrice);
            }
        }

        public int getCount() {
            return this.count;
        }

        public double getAverage() {
            return this.count == 0 ? 0.0 : this.sum / (double)this.count;
        }

        public double getMin() {
            return this.count == 0 ? 0.0 : this.min;
        }

        public double getMax() {
            return this.count == 0 ? 0.0 : this.max;
        }

        public double getMedian() {
            if (this.values.isEmpty()) {
                return 0.0;
            }
            ArrayList<Double> sorted = new ArrayList<Double>(this.values);
            Collections.sort(sorted);
            int n = sorted.size();
            if (n % 2 == 1) {
                return (Double)sorted.get(n / 2);
            }
            return ((Double)sorted.get(n / 2 - 1) + (Double)sorted.get(n / 2)) / 2.0;
        }

        public double getQuartile1() {
            if (this.values.isEmpty()) {
                return 0.0;
            }
            ArrayList<Double> sorted = new ArrayList<Double>(this.values);
            Collections.sort(sorted);
            int n = sorted.size();
            List<Double> lowerHalf = sorted.subList(0, n / 2);
            return this.median(lowerHalf);
        }

        public double getQuartile3() {
            if (this.values.isEmpty()) {
                return 0.0;
            }
            ArrayList<Double> sorted = new ArrayList<Double>(this.values);
            Collections.sort(sorted);
            int n = sorted.size();
            List<Double> upperHalf = n % 2 == 0 ? sorted.subList(n / 2, n) : sorted.subList(n / 2 + 1, n);
            return this.median(upperHalf);
        }

        private double median(List<Double> list) {
            int size = list.size();
            if (size == 0) {
                return 0.0;
            }
            if (size % 2 == 1) {
                return list.get(size / 2);
            }
            return (list.get(size / 2 - 1) + list.get(size / 2)) / 2.0;
        }
    }
}

