/*
 * Decompiled with CFR 0.152.
 */
package pl.lordtricker.ltrynek.client.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Messages {
    private static final Map<String, List<String>> messages = new HashMap<String, List<String>>();

    public static String get(String key) {
        List<String> lines = messages.get(key);
        if (lines == null) {
            return "Missing message for key: " + key;
        }
        return String.join((CharSequence)"\n", lines);
    }

    public static String format(String key, Map<String, String> placeholders) {
        List<String> lines = messages.get(key);
        if (lines == null) {
            return "Missing message for key: " + key;
        }
        ArrayList<String> replaced = new ArrayList<String>();
        for (String line : lines) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                line = line.replace("%" + entry.getKey() + "%", entry.getValue());
            }
            replaced.add(line);
        }
        return String.join((CharSequence)"\n", replaced);
    }

    static {
        try (InputStream in = Messages.class.getResourceAsStream("/assets/ltrynek/messages/messages.json");){
            if (in == null) {
                System.err.println("messages.json not found in resources!");
            } else {
                Type type = new TypeToken<Map<String, List<String>>>(){}.getType();
                Map loaded = (Map)new Gson().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), type);
                if (loaded != null) {
                    messages.putAll(loaded);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

