package com.emonadeo.autorun;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class AutoRunModMenu implements ModMenuApi, ConfigScreenFactory<class_437> {

	@Override
	public ConfigScreenFactory<class_437> getModConfigScreenFactory() {
		return this;
	}

	@Override
	public class_437 create(class_437 screen) {
		ConfigBuilder builder = ConfigBuilder.create()
				.setParentScreen(screen)
				.setTitle(class_2561.method_43471("title." + AutoRunMod.MODID + ".config"));

		ConfigEntryBuilder entryBuilder = builder.entryBuilder();
		ConfigCategory general = builder
				.getOrCreateCategory(class_2561.method_43471("config." + AutoRunMod.MODID + ".general"));

		// Always Sprint
		general.addEntry(entryBuilder
				.startBooleanToggle(
						class_2561.method_43471(
								"config." + AutoRunMod.MODID + ".alwaysSprint"),
						AutoRunMod.alwaysSprint)
				.setDefaultValue(false)
				.setTooltip(class_2561.method_43471(
						"config." + AutoRunMod.MODID + ".alwaysSprint"))
				.setSaveConsumer((value) -> AutoRunMod.alwaysSprint = value)
				.build());

		// Persist Auto-Run
		general.addEntry(entryBuilder
				.startBooleanToggle(
						class_2561.method_43471(
								"config." + AutoRunMod.MODID + ".persistAutoRun"),
						AutoRunMod.persistAutoRun)
				.setDefaultValue(false)
				.setTooltip(class_2561.method_43471(
						"config." + AutoRunMod.MODID + ".persistAutoRun.description"))
				.setSaveConsumer((value) -> AutoRunMod.persistAutoRun = value)
				.build());

		// Show Message
		general.addEntry(entryBuilder
				.startBooleanToggle(
						class_2561.method_43471(
								"config." + AutoRunMod.MODID + ".showMessage"),
						AutoRunMod.showMessage)
				.setDefaultValue(true)
				.setTooltip(class_2561.method_43471(
						"config." + AutoRunMod.MODID + ".showMessage.description"))
				.setSaveConsumer((value) -> AutoRunMod.showMessage = value)
				.build());

		// Toggle Auto-Jump
		general.addEntry(entryBuilder
				.startBooleanToggle(
						class_2561.method_43471(
								"config." + AutoRunMod.MODID + ".toggleAutoJump"),
						AutoRunMod.toggleAutoJump)
				.setDefaultValue(true)
				.setTooltip(class_2561.method_43471(
						"config." + AutoRunMod.MODID + ".toggleAutoJump.description"))
				.setSaveConsumer((value) -> AutoRunMod.toggleAutoJump = value)
				.build());

		return builder.setSavingRunnable(() -> {
			AutoRunMod.saveConfig(AutoRunMod.CFG_FILE);
			AutoRunMod.loadConfig(AutoRunMod.CFG_FILE);
		}).build();
	}
}
