/*
 * Decompiled with CFR 0.152.
 */
package com.emonadeo.autorun;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10185;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;

public class AutoRunMod
implements ClientModInitializer {
    public static final String MODID = "autorun";
    public static final File CFG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "autorun.properties");
    public static boolean alwaysSprint = false;
    public static boolean persistAutoRun = false;
    public static boolean showMessage = true;
    public static boolean toggleAutoJump = true;
    public static boolean forward = false;
    public static boolean backward = false;
    public static boolean left = false;
    public static boolean right = false;
    public static boolean sprint = false;
    private static boolean activating = false;
    private static boolean originalAutoJumpSetting = false;
    private static class_304 keyBinding;

    public void onInitializeClient() {
        AutoRunMod.loadConfig(CFG_FILE);
        AutoRunMod.saveConfig(CFG_FILE);
        keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.autorun.toggle", class_3675.class_307.field_1668, 79, class_304.class_11900.field_62555));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (keyBinding.method_1436() && client.field_1687 != null) {
                if (forward || backward || left || right) {
                    AutoRunMod.disableAutoRun(client);
                    continue;
                }
                AutoRunMod.enableAutoRun(client);
                activating = true;
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (activating) {
                if (forward && !client.field_1690.field_1894.method_1434() || backward && !client.field_1690.field_1881.method_1434() || left && !client.field_1690.field_1913.method_1434() || right && !client.field_1690.field_1849.method_1434()) {
                    activating = false;
                }
                return;
            }
            if ((forward || backward) && (client.field_1690.field_1894.method_1434() || client.field_1690.field_1881.method_1434())) {
                AutoRunMod.disableAutoRun(client);
            }
            if ((left || right) && (client.field_1690.field_1913.method_1434() || client.field_1690.field_1849.method_1434())) {
                AutoRunMod.disableAutoRun(client);
            }
        });
        ClientEntityEvents.ENTITY_UNLOAD.register((entity, clientWorld) -> {
            if (entity instanceof class_746 && !persistAutoRun) {
                AutoRunMod.disableAutoRun(class_310.method_1551());
            }
        });
    }

    private static void enableAutoRun(class_310 client) {
        class_10185 input;
        if (showMessage) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Activating Auto-Run"), false);
        }
        if (toggleAutoJump) {
            originalAutoJumpSetting = (Boolean)client.field_1690.method_42423().method_41753();
            client.field_1690.method_42423().method_41748((Object)true);
            client.field_1690.method_1643();
        }
        if (client.field_1724.method_5624() || alwaysSprint) {
            sprint = true;
        }
        if (!((input = client.field_1724.field_3913.field_54155).comp_3159() || input.comp_3160() || input.comp_3161() || input.comp_3162())) {
            forward = true;
            return;
        }
        if (input.comp_3159()) {
            forward = true;
        }
        if (input.comp_3160()) {
            backward = true;
        }
        if (input.comp_3161()) {
            left = true;
        }
        if (input.comp_3162()) {
            right = true;
        }
    }

    private static void disableAutoRun(class_310 client) {
        if (showMessage) {
            client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"Deactivating Auto-Run"), false);
        }
        forward = false;
        backward = false;
        left = false;
        right = false;
        sprint = false;
        if (toggleAutoJump) {
            client.field_1690.method_42423().method_41748((Object)originalAutoJumpSetting);
            client.field_1690.method_1643();
        }
    }

    public static void loadConfig(File file) {
        try {
            Properties cfg = new Properties();
            if (!file.exists()) {
                AutoRunMod.saveConfig(file);
            }
            cfg.load(new FileInputStream(file));
            alwaysSprint = Boolean.parseBoolean(cfg.getProperty("alwaysSprint", "false"));
            persistAutoRun = Boolean.parseBoolean(cfg.getProperty("persistAutoRun", "false"));
            showMessage = Boolean.parseBoolean(cfg.getProperty("showMessage", "true"));
            toggleAutoJump = Boolean.parseBoolean(cfg.getProperty("toggleAutoJump", "true"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file, false);
            fos.write(("alwaysSprint=" + alwaysSprint + "\n").getBytes());
            fos.write(("persistAutoRun=" + persistAutoRun + "\n").getBytes());
            fos.write(("showMessage=" + showMessage + "\n").getBytes());
            fos.write(("toggleAutoJump=" + toggleAutoJump + "\n").getBytes());
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

