/*
 * Decompiled with CFR 0.152.
 */
package me.sintaxlabs.YouCantHaveThat;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class main
extends JavaPlugin
implements Listener {
    private Set<Material> blockedItems;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        Objects.requireNonNull(this.getCommand("reloadconfig")).setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("YouCantHaveThat Enabled");
        Global.configAntiBlockBreak = this.getConfig().getBoolean("AntiBreak");
        Global.configBreakIntoAir = this.getConfig().getBoolean("BreakIntoAir");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (sender == null) {
            main.$$$reportNull$$$0(0);
        }
        if (command == null) {
            main.$$$reportNull$$$0(1);
        }
        if (label == null) {
            main.$$$reportNull$$$0(2);
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7eUsage: /youcanthavethat reload");
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("youcanthavethat.reload")) {
                this.reloadConfig();
                this.loadConfiguration();
                sender.sendMessage("\u00a77[\u00a76YouCantHaveThat\u00a77] \u00a7aConfig reloaded.");
            } else {
                sender.sendMessage("\u00a7cYou don't have permission to do that.");
            }
            return true;
        }
        sender.sendMessage("\u00a7cUnknown subcommand.");
        return true;
    }

    private void loadConfiguration() {
        Global.configAntiBlockBreak = this.getConfig().getBoolean("AntiBreak");
        Global.configBreakIntoAir = this.getConfig().getBoolean("BreakIntoAir");
        this.blockedItems = new HashSet<Material>();
        FileConfiguration config = this.getConfig();
        List blockNames = config.getStringList("blocked-items");
        for (String name : blockNames) {
            try {
                Material material = Material.valueOf((String)name.toUpperCase());
                this.blockedItems.add(material);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid block type in config: " + name);
            }
        }
    }

    @EventHandler
    public void interactionCheck(PlayerInteractEvent e) {
        Material material = e.getMaterial();
        Player player = e.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack secondHand = inventory.getItemInOffHand();
        if (!player.hasPermission("youcanthavethat.bypass") && this.blockedItems.contains(material)) {
            e.setCancelled(true);
            this.checkInventoryProcess(inventory, secondHand);
        }
    }

    @EventHandler
    public void blockBreakChecker(BlockBreakEvent e) {
        Material material = e.getBlock().getType();
        Player player = e.getPlayer();
        Block block = e.getBlock();
        if (!player.hasPermission("youcanthavethat.bypass") && Global.configAntiBlockBreak && this.blockedItems.contains(material)) {
            if (Global.configBreakIntoAir) {
                block.setType(Material.AIR);
            } else {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void inventoryCheck1(InventoryOpenEvent e) {
        Player player = (Player)e.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack secondHand = inventory.getItemInOffHand();
        if (!player.hasPermission("youcanthavethat.bypass")) {
            this.checkInventoryProcess(inventory, secondHand);
        }
    }

    @EventHandler
    public void inventoryCheck2(EntityPickupItemEvent e) {
        Item item = e.getItem();
        Player player = (Player)e.getEntity();
        PlayerInventory inventory = player.getInventory();
        ItemStack secondHand = inventory.getItemInOffHand();
        @NotNull LivingEntity entity = e.getEntity();
        @NotNull Material material = e.getItem().getItemStack().getType();
        if (entity instanceof Player && !player.hasPermission("youcanthavethat.bypass") && this.blockedItems.contains(material)) {
            e.setCancelled(true);
            item.remove();
            this.checkInventoryProcess(inventory, secondHand);
        }
    }

    private void checkInventoryProcess(PlayerInventory inventory, ItemStack secondHand) {
        for (ItemStack item : inventory.getContents()) {
            if (item == null || !this.blockedItems.contains(item.getType())) continue;
            inventory.remove(item.getType());
            this.getServer().getScheduler().runTaskLater((Plugin)this, task -> inventory.remove(item.getType()), 40L);
        }
        if (this.blockedItems.contains(secondHand.getType())) {
            inventory.setItemInOffHand(null);
        }
    }

    public void onDisable() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sender";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "command";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "label";
                break;
            }
        }
        objectArray[1] = "me/sintaxlabs/YouCantHaveThat/main";
        objectArray[2] = "onCommand";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Global {
        public static boolean configAntiBlockBreak;
        public static boolean configBreakIntoAir;
    }
}

