/*
 * Decompiled with CFR 0.152.
 */
package com.fpshud;

import com.fpshud.FPShudClient;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigManager {
    private static Config config;
    private static final Path configPath;

    protected static void loadConfig() {
        Gson gson = new Gson();
        File configFile = configPath.toFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)gson.fromJson((Reader)reader, Config.class);
                if (config == null) {
                    ConfigManager.restoreDefaultConfig();
                }
            }
            catch (JsonSyntaxException | IOException exception) {
                ConfigManager.restoreDefaultConfig();
            }
        } else {
            ConfigManager.restoreDefaultConfig();
        }
        ConfigManager.applyConfig();
    }

    private static void restoreDefaultConfig() {
        config = new Config();
        ConfigManager.config.toggleHUD = FPShudClient.toggleHUD;
        ConfigManager.config.xPos = FPShudClient.xPos;
        ConfigManager.config.yPos = FPShudClient.yPos;
        ConfigManager.config.textColor = FPShudClient.textColor;
        ConfigManager.config.shadow = FPShudClient.shadow;
        ConfigManager.config.pollingRate = FPShudClient.pollingRate;
        ConfigManager.config.showFps = FPShudClient.showFps;
        ConfigManager.config.fpsPosition = FPShudClient.fpsPosition;
        ConfigManager.config.fpsPrecision = FPShudClient.fpsPrecision;
        ConfigManager.config.beforeFps = FPShudClient.beforeFps;
        ConfigManager.config.afterFps = FPShudClient.afterFps;
        ConfigManager.config.mainUpdateInterval = FPShudClient.mainUpdateInterval;
        ConfigManager.config.showAvr = FPShudClient.showAvr;
        ConfigManager.config.avrPosition = FPShudClient.avrPosition;
        ConfigManager.config.avrPrecision = FPShudClient.avrPrecision;
        ConfigManager.config.beforeAvr = FPShudClient.beforeAvr;
        ConfigManager.config.afterAvr = FPShudClient.afterAvr;
        ConfigManager.config.avrUpdateInterval = FPShudClient.avrUpdateInterval;
        ConfigManager.config.showMax = FPShudClient.showMax;
        ConfigManager.config.maxPosition = FPShudClient.maxPosition;
        ConfigManager.config.maxPrecision = FPShudClient.maxPrecision;
        ConfigManager.config.beforeMax = FPShudClient.beforeMax;
        ConfigManager.config.afterMax = FPShudClient.afterMax;
        ConfigManager.config.maxUpdateInterval = FPShudClient.maxUpdateInterval;
        ConfigManager.config.showMin = FPShudClient.showMin;
        ConfigManager.config.minPosition = FPShudClient.minPosition;
        ConfigManager.config.minPrecision = FPShudClient.minPrecision;
        ConfigManager.config.beforeMin = FPShudClient.beforeMin;
        ConfigManager.config.afterMin = FPShudClient.afterMin;
        ConfigManager.config.minUpdateInterval = FPShudClient.minUpdateInterval;
        ConfigManager.saveConfig();
    }

    private static void applyConfig() {
        FPShudClient.toggleHUD = ConfigManager.config.toggleHUD;
        FPShudClient.xPos = ConfigManager.config.xPos;
        FPShudClient.yPos = ConfigManager.config.yPos;
        FPShudClient.textColor = ConfigManager.config.textColor;
        FPShudClient.shadow = ConfigManager.config.shadow;
        FPShudClient.pollingRate = ConfigManager.config.pollingRate;
        FPShudClient.showFps = ConfigManager.config.showFps;
        FPShudClient.fpsPosition = ConfigManager.config.fpsPosition;
        FPShudClient.fpsPrecision = ConfigManager.config.fpsPrecision;
        FPShudClient.beforeFps = ConfigManager.config.beforeFps;
        FPShudClient.afterFps = ConfigManager.config.afterFps;
        FPShudClient.mainUpdateInterval = ConfigManager.config.mainUpdateInterval;
        FPShudClient.showAvr = ConfigManager.config.showAvr;
        FPShudClient.avrPosition = ConfigManager.config.avrPosition;
        FPShudClient.avrPrecision = ConfigManager.config.avrPrecision;
        FPShudClient.beforeAvr = ConfigManager.config.beforeAvr;
        FPShudClient.afterAvr = ConfigManager.config.afterAvr;
        FPShudClient.avrUpdateInterval = ConfigManager.config.avrUpdateInterval;
        FPShudClient.showMax = ConfigManager.config.showMax;
        FPShudClient.maxPosition = ConfigManager.config.maxPosition;
        FPShudClient.maxPrecision = ConfigManager.config.maxPrecision;
        FPShudClient.beforeMax = ConfigManager.config.beforeMax;
        FPShudClient.afterMax = ConfigManager.config.afterMax;
        FPShudClient.maxUpdateInterval = ConfigManager.config.maxUpdateInterval;
        FPShudClient.showMin = ConfigManager.config.showMin;
        FPShudClient.minPosition = ConfigManager.config.minPosition;
        FPShudClient.minPrecision = ConfigManager.config.minPrecision;
        FPShudClient.beforeMin = ConfigManager.config.beforeMin;
        FPShudClient.afterMin = ConfigManager.config.afterMin;
        FPShudClient.minUpdateInterval = ConfigManager.config.minUpdateInterval;
        ConfigManager.saveConfig();
    }

    protected static void saveConfig() {
        Gson gson = new Gson();
        File configFile = configPath.toFile();
        Config currentConfig = new Config();
        currentConfig.toggleHUD = FPShudClient.toggleHUD;
        currentConfig.xPos = FPShudClient.xPos;
        currentConfig.yPos = FPShudClient.yPos;
        currentConfig.textColor = FPShudClient.textColor;
        currentConfig.shadow = FPShudClient.shadow;
        currentConfig.pollingRate = FPShudClient.pollingRate;
        currentConfig.showFps = FPShudClient.showFps;
        currentConfig.fpsPosition = FPShudClient.fpsPosition;
        currentConfig.fpsPrecision = FPShudClient.fpsPrecision;
        currentConfig.beforeFps = FPShudClient.beforeFps;
        currentConfig.afterFps = FPShudClient.afterFps;
        currentConfig.mainUpdateInterval = FPShudClient.mainUpdateInterval;
        currentConfig.showAvr = FPShudClient.showAvr;
        currentConfig.avrPosition = FPShudClient.avrPosition;
        currentConfig.avrPrecision = FPShudClient.avrPrecision;
        currentConfig.beforeAvr = FPShudClient.beforeAvr;
        currentConfig.afterAvr = FPShudClient.afterAvr;
        currentConfig.avrUpdateInterval = FPShudClient.avrUpdateInterval;
        currentConfig.showMax = FPShudClient.showMax;
        currentConfig.maxPosition = FPShudClient.maxPosition;
        currentConfig.maxPrecision = FPShudClient.maxPrecision;
        currentConfig.beforeMax = FPShudClient.beforeMax;
        currentConfig.afterMax = FPShudClient.afterMax;
        currentConfig.maxUpdateInterval = FPShudClient.maxUpdateInterval;
        currentConfig.showMin = FPShudClient.showMin;
        currentConfig.minPosition = FPShudClient.minPosition;
        currentConfig.minPrecision = FPShudClient.minPrecision;
        currentConfig.beforeMin = FPShudClient.beforeMin;
        currentConfig.afterMin = FPShudClient.afterMin;
        currentConfig.minUpdateInterval = FPShudClient.minUpdateInterval;
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)currentConfig, (Appendable)writer);
        }
        catch (IOException exception) {
            ConfigManager.restoreDefaultConfig();
        }
    }

    static {
        configPath = FabricLoader.getInstance().getConfigDir().resolve("FPShud.json");
    }

    @Environment(value=EnvType.CLIENT)
    private static class Config {
        boolean toggleHUD;
        int xPos;
        int yPos;
        int textColor;
        boolean shadow;
        int pollingRate;
        boolean showFps;
        int fpsPosition;
        int fpsPrecision;
        String beforeFps;
        String afterFps;
        int mainUpdateInterval;
        boolean showAvr;
        int avrPosition;
        int avrPrecision;
        String beforeAvr;
        String afterAvr;
        int avrUpdateInterval;
        boolean showMax;
        int maxPosition;
        int maxPrecision;
        String beforeMax;
        String afterMax;
        int maxUpdateInterval;
        boolean showMin;
        int minPosition;
        int minPrecision;
        String beforeMin;
        String afterMin;
        int minUpdateInterval;

        private Config() {
        }
    }
}

