/*
 * Decompiled with CFR 0.152.
 */
package com.fpshud;

import com.fpshud.ConfigManager;
import java.util.Iterator;
import java.util.LinkedList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class FPShudClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FPShudClient.class);
    private static final LinkedList<Double> fpsHistory = new LinkedList();
    private static final LinkedList<Double> avrFpsHistory = new LinkedList();
    private static final LinkedList<Double> maxFpsHistory = new LinkedList();
    private static final LinkedList<Double> minFpsHistory = new LinkedList();
    private static long lastPollTime = System.currentTimeMillis();
    private static long lastFrameTime = System.nanoTime();
    private static double lastPoll = 0.0;
    private static double lastTimeMainClear = 0.0;
    private static double lastTimeAvrClear = 0.0;
    private static double lastTimeMaxClear = 0.0;
    private static double lastTimeMinClear = 0.0;
    private static double mainFps = 0.0;
    private static double displayFps = 0.0;
    private static double avrFps = 0.0;
    private static double maxFps = 0.0;
    private static double minFps = 0.0;
    protected static boolean toggleHUD = true;
    protected static int xPos = 5;
    protected static int yPos = 5;
    protected static int textColor = 0xFFFFFF;
    protected static boolean shadow = true;
    protected static int pollingRate = 100;
    protected static boolean showFps = true;
    protected static int fpsPosition = 1;
    protected static int fpsPrecision = 0;
    protected static String beforeFps = "FPS: ";
    protected static String afterFps = " | ";
    protected static int mainUpdateInterval = 250;
    protected static boolean showAvr = true;
    protected static int avrPosition = 2;
    protected static int avrPrecision = 0;
    protected static String beforeAvr = "Avr: ";
    protected static String afterAvr = " | ";
    protected static int avrUpdateInterval = 2000;
    protected static boolean showMax = true;
    protected static int maxPosition = 3;
    protected static int maxPrecision = 0;
    protected static String beforeMax = "Max: ";
    protected static String afterMax = " | ";
    protected static int maxUpdateInterval = 2000;
    protected static boolean showMin = true;
    protected static int minPosition = 4;
    protected static int minPrecision = 0;
    protected static String beforeMin = "Min: ";
    protected static String afterMin = "";
    protected static int minUpdateInterval = 2000;

    public void onInitializeClient() {
        ConfigManager.loadConfig();
        WorldRenderEvents.END.register(context -> FPShudClient.updateFps());
        HudElementRegistry.addLast((class_2960)class_2960.method_60655((String)"fpshud", (String)"hud"), (context, tickCounter) -> context.method_51433(class_310.method_1551().field_1772, FPShudClient.getFullString(), xPos, yPos, 0xFF000000 | textColor & 0xFFFFFF, shadow));
        LOGGER.info("FPShud initialized");
    }

    private static void updateFps() {
        long currentTime = System.nanoTime();
        long deltaTime = currentTime - lastFrameTime;
        lastFrameTime = currentTime;
        fpsHistory.add(1.0E9 / (double)deltaTime);
        FPShudClient.incrementVariables();
    }

    private static void incrementVariables() {
        long deltaTime = System.currentTimeMillis() - lastPollTime;
        if (deltaTime > 0L) {
            lastPoll += (double)deltaTime;
            lastTimeMainClear += (double)deltaTime;
            lastTimeAvrClear += (double)deltaTime;
            lastTimeMaxClear += (double)deltaTime;
            lastTimeMinClear += (double)deltaTime;
            lastPollTime = System.currentTimeMillis();
        }
        if (lastPoll > (double)pollingRate) {
            double acc = 0.0;
            Iterator iterator = fpsHistory.iterator();
            while (iterator.hasNext()) {
                double fps = (Double)iterator.next();
                acc += fps;
            }
            mainFps = acc / (double)fpsHistory.size();
            fpsHistory.clear();
            avrFpsHistory.add(mainFps);
            maxFpsHistory.add(mainFps);
            minFpsHistory.add(mainFps);
            lastPoll = 0.0;
        }
        if (lastTimeMainClear > (double)mainUpdateInterval) {
            displayFps = mainFps;
            lastTimeMainClear = 0.0;
        }
        if (lastTimeAvrClear > (double)avrUpdateInterval) {
            avrFps = FPShudClient.calcAvrFps();
            avrFpsHistory.clear();
            lastTimeAvrClear = 0.0;
        }
        if (lastTimeMaxClear > (double)maxUpdateInterval) {
            maxFps = FPShudClient.calcMaxFps();
            maxFpsHistory.clear();
            lastTimeMaxClear = 0.0;
        }
        if (lastTimeMinClear > (double)minUpdateInterval) {
            minFps = FPShudClient.calcMinFps();
            minFpsHistory.clear();
            lastTimeMinClear = 0.0;
        }
    }

    private static String getFullString() {
        if (!toggleHUD || class_310.method_1551().field_1755 != null) {
            return "";
        }
        String[] components = new String[4];
        if (showFps) {
            components[FPShudClient.fpsPosition - 1] = beforeFps + String.format("%." + fpsPrecision + "f", displayFps) + afterFps;
        }
        if (showAvr) {
            components[FPShudClient.avrPosition - 1] = beforeAvr + String.format("%." + avrPrecision + "f", avrFps) + afterAvr;
        }
        if (showMax) {
            components[FPShudClient.maxPosition - 1] = beforeMax + String.format("%." + maxPrecision + "f", maxFps) + afterMax;
        }
        if (showMin) {
            components[FPShudClient.minPosition - 1] = beforeMin + String.format("%." + minPrecision + "f", minFps) + afterMin;
        }
        StringBuilder fpsDisplay = new StringBuilder();
        for (String component : components) {
            if (component == null) continue;
            fpsDisplay.append(component);
        }
        return fpsDisplay.toString();
    }

    private static double calcAvrFps() {
        double acc = 0.0;
        Iterator iterator = avrFpsHistory.iterator();
        while (iterator.hasNext()) {
            double fps = (Double)iterator.next();
            acc += fps;
        }
        return acc / (double)avrFpsHistory.size();
    }

    private static double calcMaxFps() {
        double max = mainFps;
        Iterator iterator = maxFpsHistory.iterator();
        while (iterator.hasNext()) {
            double fps = (Double)iterator.next();
            if (!(fps > max)) continue;
            max = fps;
        }
        return max;
    }

    private static double calcMinFps() {
        double min = mainFps;
        Iterator iterator = minFpsHistory.iterator();
        while (iterator.hasNext()) {
            double fps = (Double)iterator.next();
            if (!(fps < min)) continue;
            min = fps;
        }
        return min;
    }

    protected static int maxPollingRate() {
        int min = Integer.MAX_VALUE;
        if (mainUpdateInterval < min) {
            min = mainUpdateInterval;
        }
        if (avrUpdateInterval < min) {
            min = avrUpdateInterval;
        }
        if (maxUpdateInterval < min) {
            min = maxUpdateInterval;
        }
        if (minUpdateInterval < min) {
            min = maxUpdateInterval;
        }
        return min - 1;
    }
}

