/*
 * Decompiled with CFR 0.152.
 */
package Transformers;

import Transformers.DownloadTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;

public class LoadTransformer
implements ClassFileTransformer {
    private static final Logger LOGGER = Logger.getLogger(DownloadTransformer.class.getName());

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (className.equals("com/sk89q/worldedit/command/SchematicCommands")) {
            try {
                ClassPool cp = ClassPool.getDefault();
                cp.insertClassPath(new LoaderClassPath(loader));
                CtClass cc = cp.get("com.sk89q.worldedit.command.SchematicCommands");
                CtMethod m = cc.getDeclaredMethod("load");
                m.instrument(new ExprEditor(){

                    @Override
                    public void edit(MethodCall mc) throws CannotCompileException {
                        if (mc.getClassName().equals("java.util.UUID") && mc.getMethodName().equals("fromString")) {
                            mc.replace("{ $_ = null;}");
                        }
                    }

                    @Override
                    public void edit(NewExpr e) throws CannotCompileException {
                        if (e.getClassName().equals("java.net.URL")) {
                            String sig = e.getSignature();
                            if (sig.equals("(Ljava/lang/String;)V")) {
                                e.replace("{ $_ = new java.net.URL(com.fastasyncworldedit.core.configuration.Settings.settings().WEB.ARKITEKTONIKA_BACKEND_URL);}");
                            }
                            if (sig.equals("(Ljava/net/URL;Ljava/lang/String;)V")) {
                                e.replace("{ $_ = new java.net.URL($1, \"download/\" + filename.substring(4));}");
                            }
                        }
                    }
                });
                byte[] byteCode = cc.toBytecode();
                cc.detach();
                return byteCode;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to transform SchematicCommands class", e);
            }
        }
        return null;
    }
}

