/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.autocrafting;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.api.recipe.transfer.IAutocraftingHandler;
import mezz.jei.autocrafting.AutocraftingHandler;
import mezz.jei.autocrafting.RecipeBookmarkItem;
import mezz.jei.autocrafting.RecipeChain;
import mezz.jei.bookmarks.BookmarkGroup;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;

public class RecipeBookmarkGroup
extends BookmarkGroup {
    private final RecipeChain chain = new RecipeChain(this);

    public RecipeBookmarkGroup(int id) {
        super(id);
    }

    @Override
    public void addItemInternal(BookmarkItem<?> item) {
        super.addItemInternal(item);
    }

    @Override
    public boolean addItem(BookmarkItem<?> item) {
        if (this.canAddItem(item)) {
            this.addItemInternal(item);
            this.chain.addOutput((RecipeBookmarkItem)item);
            return true;
        }
        return false;
    }

    @Override
    public boolean canAddItem(BookmarkItem<?> item) {
        return item instanceof RecipeBookmarkItem;
    }

    @Override
    public List<BookmarkItem<?>> getItems() {
        ArrayList list = new ArrayList();
        if (!Config.areRecipeBookmarksEnabled()) {
            return list;
        }
        for (RecipeBookmarkItem<?> item : this.chain.getDisplayOutputs()) {
            if (item.secondaryTo != null || item.inputs == null || item.inputs.isEmpty()) continue;
            list.add(item);
            if (this.chain.secondaryOutputs.containsKey(item)) {
                list.addAll((Collection)this.chain.secondaryOutputs.get(item));
            }
            list.addAll(item.getInputs());
        }
        return list;
    }

    @Override
    public void finishLoading() {
        this.chain.rebuildGraph();
    }

    @Override
    public List<IIngredientListElement<?>> getIngredientListElements() {
        return this.getItems().stream().map(this::getIngredientListElement).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean acceptsChanges() {
        return false;
    }

    public void update() {
        this.chain.calculateCrafting();
    }

    @Override
    public void removeItem(BookmarkItem<?> item) {
        super.removeItem(item);
        if (item instanceof RecipeBookmarkItem) {
            this.chain.removeNode((RecipeBookmarkItem)item);
        }
    }

    public void autocraft() {
        IAutocraftingHandler handler = Internal.getRuntime().getAutocraftingHandler();
        if (!handler.isActive()) {
            ((AutocraftingHandler)Internal.getRuntime().getAutocraftingHandler()).start(this.chain);
        }
    }

    @Override
    public int getColor() {
        return Config.getRecipeBookmarkGroupColor();
    }

    public List<IIngredientListElement> getMissingIngredients() {
        ObjectArrayList missing = new ObjectArrayList();
        this.chain.calculateMissingIngredients(null, (List<BookmarkItem<?>>)missing);
        return missing.stream().map(this::getIngredientListElement).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

