/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.autocrafting.IngredientUtil;
import mezz.jei.autocrafting.RecipeBookmarkGroup;
import mezz.jei.bookmarks.BookmarkGroup;
import mezz.jei.bookmarks.BookmarkItem;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.gui.overlay.bookmarks.group.BookmarkGroupOrganizer;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.util.Log;
import org.apache.commons.io.IOUtils;

public class BookmarkList
implements IIngredientGridSource {
    private static final String MARKER_GROUP = "B:";
    private static final String MARKER_RECIPE_GROUP = "R:";
    private final List<BookmarkGroup> list = new LinkedList<BookmarkGroup>();
    private final IngredientRegistry ingredientRegistry;
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();
    private int nextId = 0;
    private BookmarkGroupOrganizer bookmarkGroupOrganizer;

    public BookmarkList(IngredientRegistry ingredientRegistry) {
        this.ingredientRegistry = ingredientRegistry;
    }

    public <T> boolean add(BookmarkItem<T> ingredient) {
        return this.add((T)ingredient, false);
    }

    public boolean add(BookmarkGroup group) {
        this.list.add(group);
        this.notifyListenersOfChange();
        this.saveBookmarks();
        return true;
    }

    public <T> boolean add(BookmarkItem<T> ingredient, boolean forceFront) {
        BookmarkItem<T> normalized = IngredientUtil.normalizeBookmark(ingredient);
        if (!this.contains(normalized)) {
            if (this.addToLists(normalized, forceFront || Config.isAddingBookmarksToFront())) {
                this.notifyListenersOfChange();
                this.saveBookmarks();
                return true;
            }
        } else if (forceFront) {
            boolean flag1 = this.remove(normalized, true);
            boolean flag2 = this.addToLists(normalized, true);
            if (flag1 || flag2) {
                this.notifyListenersOfChange();
                this.saveBookmarks();
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public <T> boolean add(T ingredient) {
        return this.add(ingredient, false);
    }

    @Deprecated
    public <T> boolean add(T ingredient, boolean forceFront) {
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        Log.get().error("Deprecated BookmarkList#add method called. Use BookmarkList#add(BookmarkItem<T>) instead. Caller: {}#{}", (Object)caller.getClassName(), (Object)caller.getMethodName());
        return this.add((T)new BookmarkItem<T>(ingredient), forceFront);
    }

    private boolean contains(Object ingredient) {
        IIngredientHelper<Object> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        for (BookmarkGroup group : this.list) {
            for (BookmarkItem<?> existing : group.getItems()) {
                if (ingredient == existing) {
                    return true;
                }
                if (existing == null || existing.getClass() != ingredient.getClass() || !ingredientHelper.getUniqueId(existing).equals(ingredientHelper.getUniqueId(ingredient))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean remove(Object ingredient) {
        return this.remove(ingredient, false);
    }

    public boolean remove(Object ingredient, boolean looseEqualCheck) {
        for (BookmarkGroup group : this.list) {
            for (int i = 0; i < group.getItems().size(); ++i) {
                String id2;
                String id1;
                BookmarkItem<?> existing = group.getItems().get(i);
                if (looseEqualCheck && (id1 = this.ingredientRegistry.getIngredientHelper(ingredient).getUniqueId(ingredient)).equals(id2 = this.ingredientRegistry.getIngredientHelper(existing).getUniqueId(existing))) {
                    this.removeItemFromGroup(group, existing);
                    return true;
                }
                if (ingredient != existing) continue;
                this.removeItemFromGroup(group, existing);
                return true;
            }
        }
        return false;
    }

    private void removeItemFromGroup(BookmarkGroup group, BookmarkItem<?> item) {
        group.removeItem(item);
        if (group.items.isEmpty() && !this.containsAnyAddableGroups()) {
            this.list.remove(group);
        }
        this.notifyListenersOfChange();
        this.saveBookmarks();
    }

    private boolean containsAnyAddableGroups() {
        return this.list.stream().anyMatch(BookmarkGroup::acceptsChanges);
    }

    public void saveBookmarks() {
        ArrayList<String> strings = new ArrayList<String>();
        for (BookmarkGroup group : this.list) {
            if (group instanceof RecipeBookmarkGroup) {
                strings.add(MARKER_RECIPE_GROUP);
            } else {
                strings.add(MARKER_GROUP);
            }
            for (BookmarkItem bookmarkItem : group.getItems()) {
                String serialized = bookmarkItem.serialize();
                if (serialized == null) continue;
                strings.add(serialized);
            }
        }
        File file = Config.getBookmarkFile();
        if (file != null) {
            try {
                FileWriter writer = new FileWriter(file);
                Object object = null;
                try {
                    IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                Log.get().error("Failed to save bookmarks list to file {}", (Object)file, (Object)e);
            }
        }
    }

    private static <T> String getUid(IIngredientListElement<T> element) {
        IIngredientHelper<T> ingredientHelper = element.getIngredientHelper();
        return ingredientHelper.getUniqueId(element.getIngredient());
    }

    public void loadBookmarks() {
        List ingredientJsonStrings;
        File file = Config.getBookmarkFile();
        if (file == null || !file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            ingredientJsonStrings = IOUtils.readLines((Reader)reader);
        }
        catch (IOException e) {
            Log.get().error("Failed to load bookmarks from file {}", (Object)file, (Object)e);
            return;
        }
        ArrayList<IIngredientType> otherIngredientTypes = new ArrayList<IIngredientType>(this.ingredientRegistry.getRegisteredIngredientTypes());
        otherIngredientTypes.remove(VanillaTypes.ITEM);
        this.list.clear();
        BookmarkGroup group = new BookmarkGroup(this.nextId++);
        for (String ingredientJsonString : ingredientJsonStrings) {
            BookmarkItem<?> item = BookmarkItem.deserialize(ingredientJsonString, otherIngredientTypes);
            if (item != null) {
                group.addItemInternal(item);
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_GROUP)) {
                if (!group.items.isEmpty()) {
                    this.list.add(group);
                }
                group = new BookmarkGroup(this.nextId++);
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_RECIPE_GROUP)) {
                if (!group.items.isEmpty()) {
                    this.list.add(group);
                }
                group = new RecipeBookmarkGroup(this.nextId++);
                continue;
            }
            Log.get().error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
        }
        if (!group.items.isEmpty()) {
            this.list.add(group);
        }
        for (BookmarkGroup newGroup : this.list) {
            newGroup.finishLoading();
        }
    }

    public BookmarkGroup getBookmarkGroup(int id) {
        for (BookmarkGroup group : this.list) {
            if (group.id != id) continue;
            return group;
        }
        return null;
    }

    public boolean removeGroup(BookmarkGroup group) {
        if (this.list.remove(group)) {
            this.notifyListenersOfChange();
            this.saveBookmarks();
            return true;
        }
        return false;
    }

    private boolean addToLists(BookmarkItem<?> ingredient, boolean addToFront) {
        return this.getAddingGroup(addToFront).addItem(ingredient, addToFront);
    }

    private BookmarkGroup getAddingGroup(boolean front) {
        if (this.list.isEmpty()) {
            this.list.add(new BookmarkGroup(this.nextId++));
        }
        if (front) {
            BookmarkGroup group = this.list.get(0);
            if (group.acceptsChanges()) {
                return group;
            }
            this.list.add(0, new BookmarkGroup(this.nextId++));
            return this.list.get(0);
        }
        BookmarkGroup group = this.list.get(this.list.size() - 1);
        if (group.acceptsChanges()) {
            return group;
        }
        this.list.add(new BookmarkGroup(this.nextId++));
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public List<IIngredientListElement> getIngredientList() {
        return this.list.stream().flatMap(group -> group.getIngredientListElements().stream()).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.getIngredientList().size();
    }

    public boolean isEmpty() {
        return this.getIngredientList().isEmpty();
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }

    public int nextId() {
        return this.nextId++;
    }

    @Nullable
    public BookmarkGroupOrganizer getGroupOrganizer() {
        return this.bookmarkGroupOrganizer;
    }

    public void setGroupOrganizer(BookmarkGroupOrganizer bookmarkGroupOrganizer) {
        this.bookmarkGroupOrganizer = bookmarkGroupOrganizer;
    }

    public int getBookmarkIndex(int id) {
        for (int index = 0; index < this.list.size(); ++index) {
            if (this.list.get((int)index).id != id) continue;
            return index;
        }
        return -1;
    }

    public boolean moveGroup(BookmarkGroup group, boolean up) {
        int groupIndex = this.getBookmarkIndex(group.id);
        if (up && groupIndex > 0) {
            Collections.swap(this.list, groupIndex, groupIndex - 1);
            this.notifyListenersOfChange();
            this.saveBookmarks();
            return true;
        }
        if (!up && groupIndex < this.list.size() - 1) {
            Collections.swap(this.list, groupIndex, groupIndex + 1);
            this.notifyListenersOfChange();
            this.saveBookmarks();
            return true;
        }
        return false;
    }
}

