/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.render.IngredientListBatchRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class TooltipRenderer {
    private TooltipRenderer() {
    }

    public static void drawHoveringText(Minecraft minecraft, String textLine, int x, int y) {
        TooltipRenderer.drawHoveringText(ItemStack.field_190927_a, minecraft, Collections.singletonList(textLine), x, y, -1, minecraft.field_71466_p);
    }

    public static void drawHoveringText(Minecraft minecraft, List<String> textLines, int x, int y) {
        TooltipRenderer.drawHoveringText(ItemStack.field_190927_a, minecraft, textLines, x, y, -1, minecraft.field_71466_p);
    }

    public static void drawHoveringText(Minecraft minecraft, List<String> textLines, int x, int y, int maxWidth) {
        TooltipRenderer.drawHoveringText(ItemStack.field_190927_a, minecraft, textLines, x, y, maxWidth, minecraft.field_71466_p);
    }

    public static void drawHoveringText(Minecraft minecraft, List<String> textLines, int x, int y, FontRenderer font) {
        TooltipRenderer.drawHoveringText(ItemStack.field_190927_a, minecraft, textLines, x, y, -1, font);
    }

    public static void drawHoveringText(Minecraft minecraft, List<String> textLines, int x, int y, int maxWidth, FontRenderer font) {
        TooltipRenderer.drawHoveringText(ItemStack.field_190927_a, minecraft, textLines, x, y, maxWidth, font);
    }

    public static void drawHoveringText(ItemStack itemStack, Minecraft minecraft, List<String> textLines, int x, int y, FontRenderer font) {
        TooltipRenderer.drawHoveringText(itemStack, minecraft, textLines, x, y, -1, font);
    }

    public static void drawHoveringText(ItemStack itemStack, Minecraft minecraft, List<String> textLines, int x, int y, int maxWidth, FontRenderer font) {
        ScaledResolution scaledresolution = new ScaledResolution(minecraft);
        GuiUtils.drawHoveringText((ItemStack)itemStack, textLines, (int)x, (int)y, (int)scaledresolution.func_78326_a(), (int)scaledresolution.func_78328_b(), (int)maxWidth, (FontRenderer)font);
    }

    public static void drawHoveringText(ItemStack itemStack, Minecraft minecraft, List<String> textLines, int x, int y, int maxWidth) {
        TooltipRenderer.drawHoveringText(itemStack, minecraft, textLines, x, y, maxWidth, minecraft.field_71466_p);
    }

    public static void drawHoveringTextAndItems(Minecraft minecraft, List<String> textLines, List<IngredientListBatchRenderer> itemLines, int x, int y) {
        TooltipRenderer.drawHoveringTextAndItems(ItemStack.field_190927_a, minecraft, textLines, itemLines, x, y, -1, minecraft.field_71466_p);
    }

    public static void drawHoveringTextAndItems(ItemStack stack, Minecraft minecraft, List<String> lines, List<IngredientListBatchRenderer> itemLines, int mouseX, int mouseY, int maxTextWidth, FontRenderer font) {
        int screenHeight;
        ScaledResolution scaledresolution = new ScaledResolution(minecraft);
        int screenWidth = scaledresolution.func_78326_a();
        RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, lines, mouseX, mouseY, screenWidth, screenHeight = scaledresolution.func_78328_b(), maxTextWidth, font);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        mouseX = event.getX();
        mouseY = event.getY();
        screenWidth = event.getScreenWidth();
        screenHeight = event.getScreenHeight();
        maxTextWidth = event.getMaxWidth();
        font = event.getFontRenderer();
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        int tooltipTextWidth = 0;
        for (String line : lines) {
            int textLineWidth = font.func_78256_a(line);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        boolean needsWrap = false;
        int titleLinesCount = 1;
        int tooltipX = mouseX + 12;
        if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
            tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
            needsWrap = true;
        }
        if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
            tooltipTextWidth = maxTextWidth;
            needsWrap = true;
        }
        if (needsWrap) {
            int wrappedTooltipWidth = 0;
            ArrayList<String> wrappedTextLines = new ArrayList<String>();
            for (int i = 0; i < lines.size(); ++i) {
                String textLine = lines.get(i);
                List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                if (i == 0) {
                    titleLinesCount = wrappedLine.size();
                }
                for (String line : wrappedLine) {
                    int lineWidth = font.func_78256_a(line);
                    if (lineWidth > wrappedTooltipWidth) {
                        wrappedTooltipWidth = lineWidth;
                    }
                    wrappedTextLines.add(line);
                }
            }
            tooltipTextWidth = wrappedTooltipWidth;
            lines = wrappedTextLines;
            tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            for (IngredientListBatchRenderer renderer : itemLines) {
                renderer.moveSlotsToFit(wrappedTooltipWidth);
            }
        } else {
            for (IngredientListBatchRenderer renderer : itemLines) {
                renderer.moveSlotsToFit(screenWidth / 2);
                tooltipTextWidth = Math.max(tooltipTextWidth, renderer.getWidth());
            }
        }
        int tooltipY = mouseY - 12;
        int tooltipHeight = 8;
        if (lines.size() > 1) {
            for (int i = 1; i < lines.size(); ++i) {
                tooltipHeight += 10;
            }
            if (lines.size() > titleLinesCount) {
                tooltipHeight += 2;
            }
        }
        if (!itemLines.isEmpty()) {
            for (IngredientListBatchRenderer renderer : itemLines) {
                tooltipHeight += renderer.getHeight();
            }
        }
        if (tooltipY < 4) {
            tooltipY = 4;
        } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - 4;
        }
        int zLevel = 300;
        int backgroundColor = -267386864;
        int borderColorStart = 0x505000FF;
        int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
        RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, lines, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)colorEvent);
        backgroundColor = colorEvent.getBackground();
        borderColorStart = colorEvent.getBorderStart();
        borderColorEnd = colorEvent.getBorderEnd();
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((int)300, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)borderColorEnd, (int)borderColorEnd);
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, lines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
        int tooltipTop = tooltipY;
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            font.func_175063_a(lines.get(lineNumber), (float)tooltipX, (float)tooltipY, -1);
            tooltipY += 10;
            if (lineNumber + 1 != titleLinesCount) continue;
            tooltipY += 2;
        }
        for (IngredientListBatchRenderer line : itemLines) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)tooltipX, (float)tooltipY, (float)300.0f);
            line.render(minecraft);
            GlStateManager.func_179121_F();
            tooltipY += line.getHeight();
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, lines, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        GlStateManager.func_179091_B();
    }
}

