/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import mezz.jei.gui.textures.TextureInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class DrawableNineSliceTexture {
    private final TextureInfo info;

    public DrawableNineSliceTexture(TextureInfo info) {
        this.info = info;
    }

    public void draw(Minecraft minecraft, int xOffset, int yOffset, int width, int height) {
        ResourceLocation location = this.info.getLocation();
        TextureAtlasSprite sprite = this.info.getSprite();
        int leftWidth = this.info.getSliceLeft();
        int rightWidth = this.info.getSliceRight();
        int topHeight = this.info.getSliceTop();
        int bottomHeight = this.info.getSliceBottom();
        int textureWidth = this.info.getWidth();
        int textureHeight = this.info.getHeight();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(location);
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uSize = uMax - uMin;
        float vSize = vMax - vMin;
        float uLeft = uMin + uSize * ((float)leftWidth / (float)textureWidth);
        float uRight = uMax - uSize * ((float)rightWidth / (float)textureWidth);
        float vTop = vMin + vSize * ((float)topHeight / (float)textureHeight);
        float vBottom = vMax - vSize * ((float)bottomHeight / (float)textureHeight);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        DrawableNineSliceTexture.draw(bufferBuilder, uMin, vMin, uLeft, vTop, xOffset, yOffset, leftWidth, topHeight);
        DrawableNineSliceTexture.draw(bufferBuilder, uMin, vBottom, uLeft, vMax, xOffset, yOffset + height - bottomHeight, leftWidth, bottomHeight);
        DrawableNineSliceTexture.draw(bufferBuilder, uRight, vMin, uMax, vTop, xOffset + width - rightWidth, yOffset, rightWidth, topHeight);
        DrawableNineSliceTexture.draw(bufferBuilder, uRight, vBottom, uMax, vMax, xOffset + width - rightWidth, yOffset + height - bottomHeight, rightWidth, bottomHeight);
        int middleWidth = textureWidth - leftWidth - rightWidth;
        int middleHeight = textureWidth - topHeight - bottomHeight;
        int tiledMiddleWidth = width - leftWidth - rightWidth;
        int tiledMiddleHeight = height - topHeight - bottomHeight;
        if (tiledMiddleWidth > 0) {
            this.drawTiled(bufferBuilder, uLeft, vMin, uRight, vTop, xOffset + leftWidth, yOffset, tiledMiddleWidth, topHeight, middleWidth, topHeight);
            this.drawTiled(bufferBuilder, uLeft, vBottom, uRight, vMax, xOffset + leftWidth, yOffset + height - bottomHeight, tiledMiddleWidth, bottomHeight, middleWidth, bottomHeight);
        }
        if (tiledMiddleHeight > 0) {
            this.drawTiled(bufferBuilder, uMin, vTop, uLeft, vBottom, xOffset, yOffset + topHeight, leftWidth, tiledMiddleHeight, leftWidth, middleHeight);
            this.drawTiled(bufferBuilder, uRight, vTop, uMax, vBottom, xOffset + width - rightWidth, yOffset + topHeight, rightWidth, tiledMiddleHeight, rightWidth, middleHeight);
        }
        if (tiledMiddleHeight > 0 && tiledMiddleWidth > 0) {
            this.drawTiled(bufferBuilder, uLeft, vTop, uRight, vBottom, xOffset + leftWidth, yOffset + topHeight, tiledMiddleWidth, tiledMiddleHeight, middleWidth, middleHeight);
        }
        tessellator.func_78381_a();
    }

    private void drawTiled(BufferBuilder bufferBuilder, float uMin, float vMin, float uMax, float vMax, int xOffset, int yOffset, int tiledWidth, int tiledHeight, int width, int height) {
        int xTileCount = tiledWidth / width;
        int xRemainder = tiledWidth - xTileCount * width;
        int yTileCount = tiledHeight / height;
        int yRemainder = tiledHeight - yTileCount * height;
        int yStart = yOffset + tiledHeight;
        float uSize = uMax - uMin;
        float vSize = vMax - vMin;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tileWidth = xTile == xTileCount ? xRemainder : width;
                int tileHeight = yTile == yTileCount ? yRemainder : height;
                int x = xOffset + xTile * width;
                int y = yStart - (yTile + 1) * height;
                if (tileWidth <= 0 || tileHeight <= 0) continue;
                int maskRight = width - tileWidth;
                int maskTop = height - tileHeight;
                float uOffset = (float)maskRight / (float)width * uSize;
                float vOffset = (float)maskTop / (float)height * vSize;
                DrawableNineSliceTexture.draw(bufferBuilder, uMin, vMin + vOffset, uMax - uOffset, vMax, x, y + maskTop, tileWidth, tileHeight);
            }
        }
    }

    private static void draw(BufferBuilder bufferBuilder, float minU, double minV, float maxU, float maxV, int xOffset, int yOffset, int width, int height) {
        bufferBuilder.func_181662_b((double)xOffset, (double)(yOffset + height), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        bufferBuilder.func_181662_b((double)(xOffset + width), (double)(yOffset + height), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        bufferBuilder.func_181662_b((double)(xOffset + width), (double)yOffset, 0.0).func_187315_a((double)maxU, minV).func_181675_d();
        bufferBuilder.func_181662_b((double)xOffset, (double)yOffset, 0.0).func_187315_a((double)minU, minV).func_181675_d();
    }
}

