/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.bookmarks.DefaultGhostIngredientHandler;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.GuiScreenHelper;
import mezz.jei.gui.ghost.GhostIngredientDrag;
import mezz.jei.gui.ghost.GhostIngredientReturning;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.input.IClickedIngredient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class GhostIngredientDragManager {
    private final GuiScreenHelper guiScreenHelper;
    private final IngredientRegistry ingredientRegistry;
    private final List<GhostIngredientReturning> ghostIngredientsReturning = new ArrayList<GhostIngredientReturning>();
    @Nullable
    private GhostIngredientDrag<?> ghostIngredientDrag;
    @Nullable
    private Object hoveredIngredient;
    @Nullable
    private List<IGhostIngredientHandler.Target<Object>> hoveredIngredientTargets;
    private final DefaultGhostIngredientHandler defaultHandler = new DefaultGhostIngredientHandler();
    @Nullable
    private IGhostIngredientHandler<?> hoverHandler;

    public GhostIngredientDragManager(GuiScreenHelper guiScreenHelper, IngredientRegistry ingredientRegistry) {
        this.guiScreenHelper = guiScreenHelper;
        this.ingredientRegistry = ingredientRegistry;
    }

    public void updateScreen(GuiScreen gui, boolean forceUpdate) {
        if (gui == null) {
            this.stopDrag();
        }
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (!(minecraft.field_71462_r instanceof GuiContainer)) {
            this.drawGhostIngredientHighlights(minecraft, mouseX, mouseY);
        }
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawItem(minecraft, mouseX, mouseY);
        }
        this.ghostIngredientsReturning.forEach(returning -> returning.drawItem(minecraft));
        this.ghostIngredientsReturning.removeIf(GhostIngredientReturning::isComplete);
    }

    public void drawOnForeground(Minecraft minecraft, GuiContainer gui, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-gui.getGuiLeft()), (float)(-gui.getGuiTop()), (float)0.0f);
        this.drawGhostIngredientHighlights(minecraft, mouseX, mouseY);
        GlStateManager.func_179121_F();
    }

    private void drawGhostIngredientHighlights(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.drawTargets(mouseX, mouseY);
        } else {
            IIngredientListElement<?> elementUnderMouse = Internal.getInputHandler().getElementUnderMouse();
            Object hovered = elementUnderMouse == null ? null : (Object)elementUnderMouse.getIngredient();
            boolean showHighlight = true;
            if (!Objects.equals(hovered, this.hoveredIngredient)) {
                this.hoveredIngredient = hovered;
                this.hoveredIngredientTargets = null;
                GuiScreen currentScreen = minecraft.field_71462_r;
                if (currentScreen != null && hovered != null) {
                    IGhostIngredientHandler<GuiScreen> handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen);
                    if (handler != null && handler.shouldHighlightTargets()) {
                        this.hoveredIngredientTargets = handler.getTargets(currentScreen, hovered, false);
                        this.hoverHandler = handler;
                    } else if (handler == null) {
                        this.hoveredIngredientTargets = this.defaultHandler.getTargets(currentScreen, hovered, false);
                        this.hoverHandler = this.defaultHandler;
                    }
                }
            }
            if (this.hoverHandler == this.defaultHandler) {
                showHighlight = false;
            }
            if (this.hoveredIngredientTargets != null && !Config.isCheatItemsEnabled() && showHighlight) {
                GhostIngredientDrag.drawTargets(mouseX, mouseY, this.hoveredIngredientTargets);
            }
        }
    }

    public boolean handleMouseClicked(Minecraft minecraft, GuiScreen currentScreen, IClickedIngredient<?> clicked, IIngredientListElement<?> listElement, int mouseX, int mouseY) {
        ItemStack mouseItem;
        if (this.ghostIngredientDrag != null) {
            boolean success = this.ghostIngredientDrag.onClick(mouseX, mouseY);
            if (!success) {
                GhostIngredientReturning<?> returning = GhostIngredientReturning.create(this.ghostIngredientDrag, mouseX, mouseY);
                this.ghostIngredientsReturning.add(returning);
            }
            this.ghostIngredientDrag = null;
            return success;
        }
        EntityPlayerSP player = minecraft.field_71439_g;
        return player != null && listElement != null && (mouseItem = player.field_71071_by.func_70445_o()).func_190926_b() && this.handleClickGhostIngredient(currentScreen, clicked);
    }

    public void stopDrag() {
        if (this.ghostIngredientDrag != null) {
            this.ghostIngredientDrag.stop();
            this.ghostIngredientDrag = null;
        }
    }

    public <T extends GuiScreen, V> boolean handleClickGhostIngredient(T currentScreen, IClickedIngredient<V> clicked) {
        if (clicked == null) {
            return false;
        }
        IGhostIngredientHandler<T> handler = this.guiScreenHelper.getGhostIngredientHandler(currentScreen);
        if (handler == null) {
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                return this.handleClickGhostIngredient(this.defaultHandler, currentScreen, clicked);
            }
            return false;
        }
        return this.handleClickGhostIngredient(handler, currentScreen, clicked);
    }

    public <T extends GuiScreen, V> boolean handleClickGhostIngredient(IGhostIngredientHandler<T> handler, T currentScreen, IClickedIngredient<V> clicked) {
        V ingredient = clicked.getValue();
        List targets = handler.getTargets(currentScreen, ingredient, true);
        if (!targets.isEmpty()) {
            IIngredientRenderer<V> ingredientRenderer = this.ingredientRegistry.getIngredientRenderer(ingredient);
            Rectangle clickedArea = clicked.getArea();
            this.ghostIngredientDrag = new GhostIngredientDrag(handler, targets, ingredientRenderer, ingredient, clickedArea);
            clicked.onClickHandled();
            return true;
        }
        return false;
    }

    public boolean handleKeyDown(int eventKey) {
        if (KeyBindings.isInventoryCloseKey(eventKey) || KeyBindings.isEnterKey(eventKey)) {
            this.stopDrag();
            return true;
        }
        return false;
    }
}

