/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import mezz.jei.config.Config;
import mezz.jei.gui.overlay.GridAlignment;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.bookmarks.group.BookmarkGroupOrganizer;
import mezz.jei.render.BookmarkListBatchRenderer;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.util.MathUtil;

public class BookmarkGrid
extends IngredientGrid {
    private static final int INGREDIENT_PADDING = 1;
    private final GridAlignment alignment;
    private Rectangle area = new Rectangle();

    public BookmarkGrid(GridAlignment alignment, BookmarkGroupOrganizer groupOrganizer) {
        super(new BookmarkListBatchRenderer(groupOrganizer), alignment);
        this.alignment = alignment;
    }

    @Override
    public boolean updateBounds(Rectangle availableArea, int minWidth, Collection<Rectangle> exclusionAreas) {
        int columns = Math.min(availableArea.width / INGREDIENT_WIDTH, Config.getMaxColumns());
        int rows = availableArea.height / INGREDIENT_HEIGHT;
        int ingredientsWidth = columns * INGREDIENT_WIDTH;
        int width = Math.max(ingredientsWidth, minWidth);
        int height = rows * INGREDIENT_HEIGHT;
        int x = this.alignment == GridAlignment.LEFT ? availableArea.x + (availableArea.width - width) : availableArea.x;
        int y = availableArea.y + (availableArea.height - height) / 2;
        int xOffset = x + Math.max(0, (width - ingredientsWidth) / 2);
        this.area = new Rectangle(x, y, width, height);
        this.guiIngredientSlots.clear();
        if (rows == 0 || columns < 4) {
            return false;
        }
        for (int row = 0; row < rows; ++row) {
            int y1 = y + row * INGREDIENT_HEIGHT;
            ArrayList<IngredientListSlot> ingredientRow = new ArrayList<IngredientListSlot>();
            for (int column = 0; column < columns; ++column) {
                int x1 = xOffset + column * INGREDIENT_WIDTH;
                IngredientListSlot ingredientListSlot = new IngredientListSlot(x1, y1, 1);
                Rectangle stackArea = ingredientListSlot.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                ingredientListSlot.setBlocked(blocked);
                ingredientRow.add(ingredientListSlot);
            }
            this.guiIngredientSlots.add(ingredientRow);
        }
        return true;
    }

    @Override
    public Rectangle getArea() {
        return this.area;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    protected IngredientListBatchRenderer getGuiIngredientSlots() {
        return this.guiIngredientSlots;
    }
}

