/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks;

import java.awt.Rectangle;
import mezz.jei.Internal;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.gui.elements.GuiLabelButton;
import mezz.jei.input.IPaged;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class BookmarkPageNavigation {
    private final IPaged paged;
    private final GuiButton nextButton;
    private final GuiButton backButton;
    private final GuiLabelButton pageLabel;
    private final boolean hideOnSinglePage;

    public BookmarkPageNavigation(IPaged paged, boolean hideOnSinglePage) {
        this.paged = paged;
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.nextButton = new GuiIconButton(0, guiHelper.getArrowNext(), (mc, mouseX, mouseY) -> paged.nextPage());
        this.backButton = new GuiIconButton(1, guiHelper.getArrowPrevious(), (mc, mouseX, mouseY) -> paged.previousPage());
        this.pageLabel = new GuiLabelButton(2, "", null);
        this.hideOnSinglePage = hideOnSinglePage;
    }

    public void updateBounds(Rectangle area) {
        int buttonSize = area.height;
        this.nextButton.field_146128_h = area.x + area.width - buttonSize;
        this.nextButton.field_146129_i = area.y;
        this.nextButton.field_146120_f = this.nextButton.field_146121_g = buttonSize;
        this.backButton.field_146128_h = area.x;
        this.backButton.field_146129_i = area.y;
        this.backButton.field_146120_f = this.backButton.field_146121_g = buttonSize;
        int pagePadding = 8;
        this.pageLabel.field_146128_h = area.x + buttonSize + pagePadding;
        this.pageLabel.field_146129_i = area.y;
        this.pageLabel.field_146120_f = area.width - buttonSize * 2 - pagePadding * 2;
        this.pageLabel.field_146121_g = buttonSize;
    }

    public void updatePageState() {
        int pageNum = this.paged.getPageNumber();
        int pageCount = this.paged.getPageCount();
        this.pageLabel.field_146126_j = pageNum + 1 + "/" + pageCount;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious()) {
            this.nextButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
            this.backButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
            this.pageLabel.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public boolean isMouseOver() {
        return this.nextButton.func_146115_a() || this.backButton.func_146115_a() || this.pageLabel.func_146115_a();
    }

    public boolean handleMouseClickedButtons(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        return this.nextButton.func_146116_c(minecraft, mouseX, mouseY) || this.backButton.func_146116_c(minecraft, mouseX, mouseY) || this.pageLabel.func_146116_c(minecraft, mouseX, mouseY);
    }
}

