/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.bookmarks.group;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.autocrafting.RecipeBookmarkGroup;
import mezz.jei.autocrafting.RecipeBookmarkItem;
import mezz.jei.bookmarks.BookmarkGroup;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.gui.overlay.bookmarks.group.BookmarkGroupDisplay;
import mezz.jei.input.MouseHelper;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class BookmarkGroupOrganizer {
    public final int GROUP_PADDING_Y = IngredientGrid.INGREDIENT_HEIGHT / 2 - 5;
    public final int GROUP_PADDING_X = 4;
    private final List<BookmarkGroupDisplay> groups = new ArrayList<BookmarkGroupDisplay>();
    private final IngredientListBatchRenderer missingIngredientRenderer = new IngredientListBatchRenderer(false);
    private Rectangle area = new Rectangle();
    private int hoveredGroupId = -1;
    private int missingIngredients = 0;

    public void updateBounds(Rectangle availableArea) {
        this.area = availableArea;
    }

    public void setBookmarkGroupIds(List<Integer> bookmarkGroupIds) {
        this.groups.clear();
        if (bookmarkGroupIds.isEmpty()) {
            return;
        }
        int startOfSequence = 0;
        int contiguousGroupId = bookmarkGroupIds.get(0);
        for (int i = 0; i < bookmarkGroupIds.size(); ++i) {
            int groupId = bookmarkGroupIds.get(i);
            if (groupId == contiguousGroupId) continue;
            this.addGroup(startOfSequence, i - 1, contiguousGroupId);
            startOfSequence = i;
            contiguousGroupId = groupId;
        }
        this.addGroup(startOfSequence, bookmarkGroupIds.size() - 1, contiguousGroupId);
    }

    private void addGroup(int start, int end, int groupId) {
        if (groupId == -1) {
            return;
        }
        BookmarkGroup group = Internal.getBookmarkList().getBookmarkGroup(groupId);
        if (group == null) {
            return;
        }
        Rectangle groupArea = this.getGroupArea(start, end, this.area);
        this.groups.add(new BookmarkGroupDisplay(groupArea, group));
    }

    private Rectangle getGroupArea(int rowStart, int rowEnd, Rectangle availableArea) {
        int rows = availableArea.height / IngredientGrid.INGREDIENT_HEIGHT;
        int height = rows * IngredientGrid.INGREDIENT_HEIGHT;
        int y = availableArea.y + (availableArea.height - height) / 2;
        return new Rectangle(0, IngredientGrid.INGREDIENT_HEIGHT * rowStart + y, availableArea.width, IngredientGrid.INGREDIENT_HEIGHT * (rowEnd - rowStart + 1));
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        if (!Config.areRecipeBookmarksEnabled()) {
            return;
        }
        for (BookmarkGroupDisplay groupDisplay : this.groups) {
            this.drawGroup(minecraft, mouseX, mouseY, groupDisplay);
        }
    }

    private void drawGroup(Minecraft minecraft, int mouseX, int mouseY, BookmarkGroupDisplay display) {
        Rectangle groupArea = display.area;
        BookmarkGroup group = display.group;
        int color = group.getColor();
        int top = groupArea.y + this.GROUP_PADDING_Y;
        int bottom = groupArea.y + groupArea.height - this.GROUP_PADDING_Y;
        int left = groupArea.x + 4;
        int right = groupArea.x + 10 - 4;
        GuiScreen.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
        GuiScreen.func_73734_a((int)left, (int)(top - 2), (int)(groupArea.x + 10), (int)top, (int)color);
        GuiScreen.func_73734_a((int)left, (int)bottom, (int)(groupArea.x + 10), (int)(bottom + 2), (int)color);
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (!Config.areRecipeBookmarksEnabled()) {
            return;
        }
        if (mouseX > this.area.x + 10) {
            this.hoveredGroupId = -1;
            return;
        }
        boolean hovered = false;
        for (BookmarkGroupDisplay group : this.groups) {
            if (mouseY < group.area.y || mouseY > group.area.y + group.area.height) continue;
            ArrayList<String> tooltips = new ArrayList<String>();
            ArrayList<IngredientListBatchRenderer> slotRows = new ArrayList<IngredientListBatchRenderer>();
            if (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) {
                tooltips.add(Translator.translateToLocal("hei.tooltip.organizer.1"));
                if (group.group instanceof RecipeBookmarkGroup) {
                    tooltips.add(Translator.translateToLocal("hei.tooltip.organizer.2"));
                    if (Config.isAutocraftingEnabled()) {
                        tooltips.add(Translator.translateToLocalFormatted("hei.tooltip.organizer.3", KeyBindings.crafting.getDisplayName()));
                    }
                }
            } else {
                hovered = true;
                tooltips.add(Translator.translateToLocal("hei.tooltip.press_alt"));
                if (group.group instanceof RecipeBookmarkGroup) {
                    if (group.group.id != this.hoveredGroupId) {
                        List<IIngredientListElement> missing = ((RecipeBookmarkGroup)group.group).getMissingIngredients();
                        this.missingIngredients = missing.size();
                        this.missingIngredientRenderer.clear();
                        ObjectArrayList slots = new ObjectArrayList();
                        for (IIngredientListElement any : missing) {
                            slots.add(new IngredientListSlot(0, 0, 1));
                        }
                        this.missingIngredientRenderer.add((List<IngredientListSlot>)slots);
                        this.missingIngredientRenderer.set(0, missing);
                    }
                    if (this.missingIngredients > 0) {
                        tooltips.add(Translator.translateToLocal("hei.tooltip.missing_ingredients"));
                        slotRows.add(this.missingIngredientRenderer);
                    }
                }
            }
            TooltipRenderer.drawHoveringTextAndItems(minecraft, tooltips, slotRows, mouseX, mouseY);
            break;
        }
        if (!hovered) {
            this.hoveredGroupId = -1;
        }
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(I ingredient) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (BookmarkGroupDisplay groupDisplay : this.groups) {
            if (groupDisplay.group instanceof RecipeBookmarkGroup ^ ingredient instanceof RecipeBookmarkItem) continue;
            targets.add(groupDisplay);
        }
        return targets;
    }

    public boolean onKeyPressed(char typedChar, int eventKey) {
        int mouseX = MouseHelper.getX();
        int mouseY = MouseHelper.getY();
        if (mouseX > this.area.x + 10) {
            return false;
        }
        for (BookmarkGroupDisplay group : this.groups) {
            if (mouseY < group.area.y || mouseY > group.area.y + group.area.height) continue;
            BookmarkList bookmarkList = Internal.getBookmarkList();
            if (Keyboard.isKeyDown((int)200) && bookmarkList.moveGroup(group.group, true)) {
                return true;
            }
            if (Keyboard.isKeyDown((int)208) && bookmarkList.moveGroup(group.group, false)) {
                return true;
            }
            if (KeyBindings.bookmark.isActiveAndMatches(eventKey) && bookmarkList.removeGroup(group.group)) {
                return true;
            }
            if (!KeyBindings.crafting.isActiveAndMatches(eventKey) || !Config.isAutocraftingEnabled() || !(group.group instanceof RecipeBookmarkGroup)) continue;
            ((RecipeBookmarkGroup)group.group).autocraft();
            return true;
        }
        return false;
    }
}

