/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IIngredientFilter;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.config.Config;
import mezz.jei.config.EditModeToggleEvent;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientListElementComparator;
import mezz.jei.search.ElementSearch;
import mezz.jei.search.ElementSearchLowMem;
import mezz.jei.search.IElementSearch;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.SearchToken;
import mezz.jei.search.TokenInfo;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IngredientFilter
implements IIngredientFilter,
IIngredientGridSource {
    public static final Pattern QUOTE_PATTERN = Pattern.compile("\"");
    public static final Pattern FILTER_SPLIT_PATTERN = Pattern.compile("(-?\".*?(?:\"|$)|\\S+)");
    public static boolean firstBuild = true;
    public static boolean rebuild = false;
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();
    private IngredientBlacklistInternal blacklist;
    private IElementSearch elementSearch;
    private List<IIngredientListElement> ingredientListCached = Collections.emptyList();
    @Nullable
    private String filterCached;
    private boolean afterBlock = false;
    @Nullable
    private List<Runnable> delegatedActions;

    public IngredientFilter(IngredientBlacklistInternal blacklist, NonNullList<IIngredientListElement> ingredients) {
        this.blacklist = blacklist;
        this.elementSearch = Config.isUltraLowMemoryMode() ? new ElementSearchLowMem() : new ElementSearch();
        this.elementSearch.addAll(ingredients);
        firstBuild = false;
    }

    public void logStatistics() {
        this.elementSearch.logStatistics();
    }

    public void addIngredients(NonNullList<IIngredientListElement> ingredients) {
        ingredients.sort((Comparator)IngredientListElementComparator.INSTANCE);
        this.elementSearch.addAll(ingredients);
        this.filterCached = null;
    }

    public <V> void addIngredient(IIngredientListElement<V> element) {
        this.updateHiddenState(element);
        this.elementSearch.add(element);
        this.filterCached = null;
    }

    public void delegateAfterBlock(Runnable runnable) {
        if (this.afterBlock) {
            runnable.run();
            this.invalidateCache();
        } else {
            if (this.delegatedActions == null) {
                this.delegatedActions = new ArrayList<Runnable>();
            }
            this.delegatedActions.add(runnable);
        }
    }

    public void block() {
        if (this.elementSearch instanceof ElementSearch) {
            ((ElementSearch)this.elementSearch).block();
        }
        this.afterBlock = true;
        if (this.delegatedActions != null) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                this.invalidateCache();
                this.delegatedActions.forEach(Runnable::run);
                this.delegatedActions = null;
                this.updateHidden();
            });
        } else {
            Minecraft.func_71410_x().func_152344_a(this::updateHidden);
        }
        this.invalidateCache();
    }

    public void invalidateCache() {
        this.filterCached = null;
    }

    public <V> List<IIngredientListElement<V>> findMatchingElements(IIngredientListElement<V> element) {
        IIngredientHelper<Object> ingredientHelper = element.getIngredientHelper();
        V ingredient = element.getIngredient();
        String ingredientUid = ingredientHelper.getUniqueId(ingredient);
        Class<?> ingredientClass = ingredient.getClass();
        ArrayList<IIngredientListElement<V>> matchingElements = new ArrayList<IIngredientListElement<V>>();
        for (IIngredientListElement<?> searchElement : this.elementSearch.getSearchResults(new TokenInfo(Translator.toLowercaseWithLocale(element.getDisplayName()), PrefixInfo.NO_PREFIX))) {
            Object castSearchElementObject;
            String searchElementUid;
            Object searchElementObject = searchElement.getIngredient();
            if (!ingredientClass.isInstance(searchElementObject) || !ingredientUid.equals(searchElementUid = ingredientHelper.getUniqueId(castSearchElementObject = ingredientClass.cast(searchElementObject)))) continue;
            matchingElements.add(searchElement);
        }
        return matchingElements;
    }

    public void modesChanged() {
        this.invalidateCache();
        if (Config.doesSearchTreeNeedReload()) {
            firstBuild = true;
            rebuild = true;
            this.afterBlock = false;
            NonNullList ingredients = NonNullList.func_193580_a(null, (Object[])this.elementSearch.getAllIngredients().toArray(new IIngredientListElement[0]));
            this.elementSearch = Config.isUltraLowMemoryMode() ? new ElementSearchLowMem() : new ElementSearch();
            ingredients.sort((Comparator)IngredientListElementComparator.INSTANCE);
            this.elementSearch.addAll((NonNullList<IIngredientListElement>)ingredients);
            if (this.elementSearch instanceof ElementSearch) {
                ((ElementSearch)this.elementSearch).block();
            }
            firstBuild = false;
            rebuild = false;
            this.afterBlock = true;
        }
    }

    @SubscribeEvent
    public void onEditModeToggleEvent(EditModeToggleEvent event) {
        this.filterCached = null;
        this.updateHidden();
    }

    public void updateHidden() {
        for (IIngredientListElement<?> element : this.elementSearch.getAllIngredients()) {
            this.updateHiddenState(element);
        }
    }

    public <V> void updateHiddenState(IIngredientListElement<V> element) {
        IIngredientHelper<V> ingredientHelper;
        boolean visible;
        V ingredient = element.getIngredient();
        boolean bl = visible = !this.blacklist.isIngredientBlacklistedByApi(ingredient, ingredientHelper = element.getIngredientHelper()) && ingredientHelper.isIngredientOnServer(ingredient) && (Config.isEditModeEnabled() || !Config.isIngredientOnConfigBlacklist(ingredient, ingredientHelper));
        if (element.isVisible() != visible) {
            element.setVisible(visible);
            this.filterCached = null;
        }
    }

    @Override
    public List<IIngredientListElement> getIngredientList() {
        return this.getIngredientList(Config.getFilterText());
    }

    public List<IIngredientListElement> getIngredientList(String filterText) {
        if (!(filterText = Translator.toLowercaseWithLocale(filterText)).equals(this.filterCached)) {
            List<IIngredientListElement<?>> ingredientList = this.getIngredientListUncached(filterText);
            this.ingredientListCached = Collections.unmodifiableList(ingredientList);
            this.filterCached = filterText;
        }
        return this.ingredientListCached;
    }

    @Override
    public ImmutableList<Object> getFilteredIngredients() {
        return this.getFilteredIngredients(Config.getFilterText());
    }

    public ImmutableList<Object> getFilteredIngredients(String filterText) {
        List<IIngredientListElement> elements = this.getIngredientList(filterText);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IIngredientListElement element : elements) {
            Object ingredient = element.getIngredient();
            builder.add(ingredient);
        }
        return builder.build();
    }

    @Override
    public String getFilterText() {
        return Config.getFilterText();
    }

    @Override
    public void setFilterText(String filterText) {
        ErrorUtil.checkNotNull(filterText, "filterText");
        if (Config.setFilterText(filterText)) {
            this.notifyListenersOfChange();
        }
    }

    private List<IIngredientListElement<?>> getIngredientListUncached(String filterText) {
        if (filterText.isEmpty()) {
            return this.elementSearch.getAllIngredients().stream().filter(IIngredientListElement::isVisible).sorted(IngredientListElementComparator.INSTANCE).collect(Collectors.toList());
        }
        List tokens = Arrays.stream(filterText.split("\\|")).map(SearchToken::parseSearchToken).filter(s -> !s.search.isEmpty()).collect(Collectors.toList());
        if (tokens.isEmpty()) {
            return this.elementSearch.getAllIngredients().stream().filter(IIngredientListElement::isVisible).sorted(IngredientListElementComparator.INSTANCE).collect(Collectors.toList());
        }
        return tokens.stream().map(token -> token.getSearchResults(this.elementSearch)).flatMap(Collection::stream).filter(IIngredientListElement::isVisible).sorted(IngredientListElementComparator.INSTANCE).collect(Collectors.toList());
    }

    public <T> List<IIngredientListElement<T>> getMatches(IIngredientListElement<T> ingredientListElement, Function<IIngredientListElement<?>, String> uidFunction) {
        IIngredientListElement ingredient;
        int i;
        List<IIngredientListElement<T>> initialSearchResult = this.findMatchingElements(ingredientListElement);
        if (initialSearchResult.isEmpty()) {
            return initialSearchResult;
        }
        String uid = uidFunction.apply(ingredientListElement);
        ArrayList<IIngredientListElement<T>> searchResult = new ArrayList<IIngredientListElement<T>>();
        for (IIngredientListElement<T> searchedElement : initialSearchResult) {
            if (!uid.equals(searchedElement.getIngredientHelper().getUniqueId(searchedElement.getIngredient()))) continue;
            searchResult.add(searchedElement);
        }
        if (!searchResult.isEmpty()) {
            return searchResult;
        }
        IntOpenHashSet matchingIndexes = new IntOpenHashSet();
        List<IIngredientListElement> ingredientList = this.getIngredientList("");
        int startingIndex = -1;
        for (IIngredientListElement<T> searchedElement : initialSearchResult) {
            int index = ingredientList.indexOf(searchedElement);
            startingIndex = Math.max(index, startingIndex);
            matchingIndexes.add(index);
            searchResult.add(searchedElement);
        }
        for (i = startingIndex - 1; i >= 0 && !matchingIndexes.contains(i); --i) {
            ingredient = ingredientList.get(i);
            String searchElementUid = uidFunction.apply(ingredient);
            if (!uid.equals(searchElementUid)) continue;
            matchingIndexes.add(i);
            searchResult.add(ingredient);
        }
        for (i = startingIndex + 1; i < ingredientList.size() && !matchingIndexes.contains(i); ++i) {
            ingredient = ingredientList.get(i);
            String searchElementUid = uidFunction.apply(ingredient);
            if (!uid.equals(searchElementUid)) continue;
            matchingIndexes.add(i);
            searchResult.add(ingredient);
        }
        return searchResult;
    }

    @Override
    public int size() {
        return this.getIngredientList().size();
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    public void replaceBlacklist(IngredientBlacklistInternal blacklist) {
        this.blacklist = blacklist;
    }

    private void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

