/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.crafting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipeWrapper;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeTippedArrow;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class CraftingRecipeChecker {
    public static boolean hasTippedArrowRecipe;

    private CraftingRecipeChecker() {
    }

    public static List<IRecipe> getValidRecipes(IJeiHelpers jeiHelpers) {
        CraftingRecipeValidator<ShapedOreRecipe> shapedOreRecipeValidator = new CraftingRecipeValidator<ShapedOreRecipe>(recipe -> new ShapedOreRecipeWrapper(jeiHelpers, (ShapedOreRecipe)recipe));
        CraftingRecipeValidator<ShapedRecipes> shapedRecipesValidator = new CraftingRecipeValidator<ShapedRecipes>(recipe -> new ShapedRecipesWrapper(jeiHelpers, (ShapedRecipes)recipe));
        CraftingRecipeValidator<ShapelessOreRecipe> shapelessOreRecipeValidator = new CraftingRecipeValidator<ShapelessOreRecipe>(recipe -> new ShapelessRecipeWrapper<ShapelessOreRecipe>(jeiHelpers, (ShapelessOreRecipe)recipe));
        CraftingRecipeValidator<ShapelessRecipes> shapelessRecipesValidator = new CraftingRecipeValidator<ShapelessRecipes>(recipe -> new ShapelessRecipeWrapper<ShapelessRecipes>(jeiHelpers, (ShapelessRecipes)recipe));
        hasTippedArrowRecipe = false;
        StackHelper stackHelper = Internal.getStackHelper();
        Iterator recipeIterator = CraftingManager.field_193380_a.iterator();
        ArrayList<IRecipe> validRecipes = new ArrayList<IRecipe>();
        while (recipeIterator.hasNext()) {
            IRecipe recipe2 = (IRecipe)recipeIterator.next();
            if (recipe2 instanceof ShapedOreRecipe) {
                if (!shapedOreRecipeValidator.isRecipeValid((ShapedOreRecipe)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapedRecipes) {
                if (!shapedRecipesValidator.isRecipeValid((ShapedRecipes)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapelessOreRecipe) {
                if (!shapelessOreRecipeValidator.isRecipeValid((ShapelessOreRecipe)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapelessRecipes) {
                if (!shapelessRecipesValidator.isRecipeValid((ShapelessRecipes)recipe2, stackHelper)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (!hasTippedArrowRecipe && recipe2 instanceof RecipeTippedArrow) {
                hasTippedArrowRecipe = true;
            }
            validRecipes.add(recipe2);
        }
        return validRecipes;
    }

    private static final class CraftingRecipeValidator<T extends IRecipe> {
        private static final int INVALID_COUNT = -1;
        private static final int CANT_DISPLAY = -2;
        private final IRecipeWrapperFactory<T> recipeWrapperFactory;

        public CraftingRecipeValidator(IRecipeWrapperFactory<T> recipeWrapperFactory) {
            this.recipeWrapperFactory = recipeWrapperFactory;
        }

        public boolean isRecipeValid(T recipe, StackHelper stackHelper) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null || recipeOutput.func_190926_b()) {
                if (!recipe.func_192399_d()) {
                    String recipeInfo = this.getInfo(recipe);
                    Log.get().error("Recipe has no output. {}", (Object)recipeInfo);
                }
                return false;
            }
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients == null) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has no input Ingredients. {}", (Object)recipeInfo);
                return false;
            }
            int inputCount = CraftingRecipeValidator.getInputCount((List<Ingredient>)ingredients, stackHelper);
            if (inputCount == -2) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().warn("Recipe contains ingredients that can't be understood or displayed by HEI: {}", (Object)recipeInfo);
                return false;
            }
            if (inputCount == -1) {
                return false;
            }
            if (inputCount > 9) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has too many inputs. {}", (Object)recipeInfo);
                return false;
            }
            if (inputCount == 0) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has no inputs. {}", (Object)recipeInfo);
                return false;
            }
            return true;
        }

        private String getInfo(T recipe) {
            IRecipeWrapper recipeWrapper = this.recipeWrapperFactory.getRecipeWrapper(recipe);
            return ErrorUtil.getInfoFromRecipe(recipe, recipeWrapper);
        }

        protected static int getInputCount(List<Ingredient> ingredientList, StackHelper stackHelper) {
            int inputCount = 0;
            for (Ingredient ingredient : ingredientList) {
                List<ItemStack> input = stackHelper.getMatchingStacks(ingredient);
                if (input == null) {
                    return -1;
                }
                if (ingredient instanceof OreIngredient && input.isEmpty()) {
                    return -1;
                }
                if (!ingredient.isSimple() && input.isEmpty()) {
                    return -2;
                }
                ++inputCount;
            }
            return inputCount;
        }
    }
}

