/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.bookmarks.group.BookmarkGroupOrganizer;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListSlot;

public class BookmarkListBatchRenderer
extends IngredientListBatchRenderer {
    private final BookmarkGroupOrganizer groupOrganizer;

    public BookmarkListBatchRenderer(BookmarkGroupOrganizer groupOrganizer) {
        this.groupOrganizer = groupOrganizer;
    }

    @Override
    public void set(int startIndex, List<IIngredientListElement> ingredientList) {
        if (!Config.areRecipeBookmarksEnabled()) {
            super.set(startIndex, ingredientList);
            return;
        }
        this.renderItems2d.clear();
        this.renderItems3d.clear();
        this.renderOther.clear();
        this.size = 0;
        for (List row : this.slots) {
            for (IngredientListSlot slot : row) {
                slot.clear();
            }
        }
        if (!ingredientList.isEmpty()) {
            int i = startIndex;
            int currentGroup = ingredientList.get(i).getGroupIndex();
            IntArrayList groupIndices = new IntArrayList();
            block2: for (List row : this.slots) {
                for (int column = 0; column < row.size(); ++column) {
                    IngredientListSlot ingredientListSlot = (IngredientListSlot)row.get(column);
                    if (ingredientListSlot.isBlocked()) {
                        if (column != 0) continue;
                        groupIndices.add(-1);
                        continue;
                    }
                    if (i >= ingredientList.size()) continue block2;
                    IIngredientListElement element = ingredientList.get(i);
                    if (element.getGroupIndex() != currentGroup || element.startsNewRow()) {
                        currentGroup = element.getGroupIndex();
                        if (column > 0) continue block2;
                    }
                    if (column == 0) {
                        groupIndices.add(currentGroup);
                    }
                    this.set(ingredientListSlot, element);
                    ++this.size;
                    ++i;
                }
            }
            this.groupOrganizer.setBookmarkGroupIds((List<Integer>)groupIndices);
        }
        this.invalidateBuffer();
    }

    public List<Integer> sizePages(List<IIngredientListElement> ingredientList) {
        IntArrayList pages = new IntArrayList();
        pages.add(0);
        if (ingredientList.isEmpty() || this.slots.isEmpty()) {
            return pages;
        }
        int ingredientIndex = 0;
        int currentGroup = ingredientList.get(ingredientIndex).getGroupIndex();
        while (true) {
            block1: for (int rowIndex = 0; rowIndex < this.slots.size(); ++rowIndex) {
                List row = (List)this.slots.get(rowIndex);
                for (int column = 0; column < row.size(); ++column) {
                    IngredientListSlot ingredientListSlot = (IngredientListSlot)row.get(column);
                    if (ingredientListSlot.isBlocked()) continue;
                    if (ingredientIndex >= ingredientList.size()) {
                        return pages;
                    }
                    IIngredientListElement element = ingredientList.get(ingredientIndex);
                    if (element.getGroupIndex() != currentGroup || element.startsNewRow()) {
                        currentGroup = element.getGroupIndex();
                        if (column > 0) continue block1;
                    }
                    ++ingredientIndex;
                }
            }
            pages.add(ingredientIndex);
        }
    }
}

