/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.PrefixInfo;
import mezz.jei.search.PrefixedSearchable;
import mezz.jei.util.Log;
import mezz.jei.util.LoggedTimer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.concurrent.ConcurrentRuntimeException;

public class AsyncPrefixedSearchable
extends PrefixedSearchable {
    private static ExecutorService service;
    private boolean firstBuild = true;
    private List<IIngredientListElement> leftovers;

    public static void startService() {
        service = Executors.newSingleThreadExecutor();
    }

    public static void endService() {
        if (service == null) {
            return;
        }
        service.shutdown();
        try {
            if (!service.awaitTermination(90L, TimeUnit.SECONDS)) {
                service.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            service.shutdownNow();
            Thread.currentThread().interrupt();
        }
        service = null;
    }

    public AsyncPrefixedSearchable(ISearchStorage<IIngredientListElement<?>> searchStorage, PrefixInfo prefixInfo) {
        super(searchStorage, prefixInfo);
    }

    @Override
    public void submitAll(NonNullList<IIngredientListElement> ingredients) {
        if (service != null) {
            service.submit(() -> {
                if (this.firstBuild) {
                    this.start();
                    this.firstBuild = false;
                }
                for (IIngredientListElement ingredient : ingredients) {
                    try {
                        this.submit(ingredient);
                    }
                    catch (ConcurrentRuntimeException e) {
                        Log.get().error(this.prefixInfo + " building failed on ingredient: " + ingredient.getDisplayName(), (Throwable)e);
                        if (this.leftovers == null) {
                            this.leftovers = new ArrayList<IIngredientListElement>();
                        }
                        this.leftovers.add(ingredient);
                    }
                }
                this.stop();
            });
        } else {
            super.submitAll(ingredients);
        }
    }

    @Override
    public void start() {
        this.timer = new LoggedTimer();
        this.timer.start("Asynchronously building [" + this.prefixInfo.getDesc() + "] search tree");
    }

    @Override
    public void stop() {
        if (this.timer != null) {
            super.stop();
        }
        if (Minecraft.func_71410_x().func_152345_ab() && this.leftovers != null && !this.leftovers.isEmpty()) {
            Log.get().info("{} search tree had {} errors, moving onto the main thread to process these errors.", (Object)this.prefixInfo, (Object)this.leftovers.size());
            this.leftovers.forEach(this::submit);
            this.leftovers = null;
        }
    }
}

