/*
 * Decompiled with CFR 0.152.
 */
package net.carlo.or_lib_mod.client.render;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.Objects;
import net.carlo.or_lib_mod.client.render.DefaultWearableTransformProviders;
import net.carlo.or_lib_mod.client.render.SlotTransform;
import net.carlo.or_lib_mod.client.render.SlotTransforms;
import net.carlo.or_lib_mod.wearable.WearableContentRegistry;
import net.carlo.or_lib_mod.wearable.WearableType;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_742;
import net.minecraft.class_809;
import net.minecraft.class_918;

public final class FirstPersonWearableRenderer {
    private FirstPersonWearableRenderer() {
    }

    public static void renderHandWearables(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 player, class_1268 hand, float tickDelta, boolean hasHeldItem) {
        if (player == null || player.method_7325()) {
            return;
        }
        TrinketsApi.getTrinketComponent((class_1309)player).ifPresent(component -> {
            for (class_3545 pair : component.getAllEquipped()) {
                SlotTransform transform;
                WearableType type;
                SlotReference slotReference = (SlotReference)pair.method_15442();
                class_1799 stack = (class_1799)pair.method_15441();
                if (stack.method_7960() || (type = WearableContentRegistry.getType(stack.method_7909())) == null || !FirstPersonWearableRenderer.isHandOrArmType(type) || !FirstPersonWearableRenderer.matchesHandGroup(slotReference, hand) || (transform = FirstPersonWearableRenderer.resolveTransform(stack, slotReference, (class_1309)player, type, hand)) == null) continue;
                FirstPersonWearableRenderer.renderWearable(matrices, vertexConsumers, light, player, stack, transform, hand, type, hasHeldItem);
            }
        });
    }

    private static boolean isHandOrArmType(WearableType type) {
        return type == WearableType.RING || type == WearableType.BRACELET;
    }

    private static boolean matchesHandGroup(SlotReference slotReference, class_1268 hand) {
        String group = slotReference.inventory().getSlotType().getGroup();
        if (hand == class_1268.field_5808) {
            return Objects.equals("hand", group);
        }
        return Objects.equals("offhand", group);
    }

    private static SlotTransform resolveTransform(class_1799 stack, SlotReference slotReference, class_1309 entity, WearableType type, class_1268 hand) {
        if (type == WearableType.RING) {
            return DefaultWearableTransformProviders.RING_BY_TRINKET_HAND.resolve(stack, slotReference, entity);
        }
        if (type == WearableType.BRACELET) {
            return hand == class_1268.field_5808 ? SlotTransforms.BRACELET_RIGHT : SlotTransforms.BRACELET_LEFT;
        }
        return null;
    }

    private static void renderWearable(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 player, class_1799 stack, SlotTransform transform, class_1268 hand, WearableType type, boolean hasHeldItem) {
        if (hasHeldItem) {
            return;
        }
        matrices.method_22903();
        FirstPersonWearableRenderer.applyFirstPersonOffset(matrices, hand, type, transform);
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_1087 model = itemRenderer.method_4019(stack, player.method_37908(), (class_1309)player, 0);
        boolean leftHanded = hand == class_1268.field_5810;
        itemRenderer.method_23179(stack, class_809.class_811.field_4316, leftHanded, matrices, vertexConsumers, light, class_4608.field_21444, model);
        matrices.method_22909();
    }

    private static void applyFirstPersonOffset(class_4587 matrices, class_1268 hand, WearableType type, SlotTransform transform) {
        float dir = hand == class_1268.field_5808 ? -1.0f : 1.0f;
        float tx = 0.08f * dir;
        float ty = -0.1f;
        float tz = 0.15f;
        if (type == WearableType.BRACELET) {
            ty += 0.01f;
        }
        float damp = 1.0f;
        matrices.method_22904((double)(tx + transform.translateX() * damp), (double)(ty + transform.translateY() * damp), (double)(tz + transform.translateZ() * damp));
        float scaleBoost = 1.0f;
        matrices.method_22905(transform.scaleX() * scaleBoost, transform.scaleY() * scaleBoost, transform.scaleZ() * scaleBoost);
        if (transform.rotateXDeg() != 0.0f) {
            matrices.method_22907(class_1160.field_20703.method_23214(transform.rotateXDeg()));
        }
        if (transform.rotateYDeg() != 0.0f) {
            matrices.method_22907(class_1160.field_20705.method_23214(transform.rotateYDeg()));
        }
        if (transform.rotateZDeg() != 0.0f) {
            matrices.method_22907(class_1160.field_20707.method_23214(transform.rotateZDeg()));
        }
    }
}

