/*
 * Decompiled with CFR 0.152.
 */
package net.carlo.or_lib_mod.wearable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.carlo.or_lib_mod.wearable.WearableItem;
import net.carlo.or_lib_mod.wearable.WearableType;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

public final class WearableContentRegistry {
    private static final EnumMap<WearableType, List<class_1792>> BY_TYPE = new EnumMap(WearableType.class);
    private static final Map<class_1792, WearableType> TYPE_BY_ITEM = new IdentityHashMap<class_1792, WearableType>();

    private WearableContentRegistry() {
    }

    public static void register(WearableItem item) {
        WearableType type = item.getWearableType();
        WearableContentRegistry.register((class_1792)item, type);
    }

    public static void register(class_1792 item, WearableType type) {
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        BY_TYPE.computeIfAbsent(type, t -> new ArrayList()).add(item);
        TYPE_BY_ITEM.put(item, type);
    }

    public static void registerAll(Iterable<? extends class_1792> items, WearableType type) {
        if (items == null) {
            throw new IllegalArgumentException("items");
        }
        for (class_1792 class_17922 : items) {
            WearableContentRegistry.register(class_17922, type);
        }
    }

    public static List<class_1792> getByType(WearableType type) {
        return Collections.unmodifiableList(BY_TYPE.getOrDefault((Object)type, List.of()));
    }

    public static List<class_1792> getRings() {
        return WearableContentRegistry.getByType(WearableType.RING);
    }

    public static List<class_1792> getNecklaces() {
        return WearableContentRegistry.getByType(WearableType.NECKLACE);
    }

    public static List<class_1792> getBelts() {
        return WearableContentRegistry.getByType(WearableType.BELT);
    }

    public static List<class_1792> getAnklets() {
        return WearableContentRegistry.getByType(WearableType.ANKLET);
    }

    public static List<class_1792> getBracelets() {
        return WearableContentRegistry.getByType(WearableType.BRACELET);
    }

    public static List<class_1792> getEarrings() {
        return WearableContentRegistry.getByType(WearableType.EARRING);
    }

    public static List<class_1792> getCrowns() {
        return WearableContentRegistry.getByType(WearableType.CROWN);
    }

    public static boolean isWearable(class_1792 item) {
        return WearableContentRegistry.getType(item) != null;
    }

    public static boolean isOfType(class_1792 item, WearableType type) {
        return WearableContentRegistry.getType(item) == type;
    }

    @Nullable
    public static WearableType getType(class_1792 item) {
        if (item instanceof WearableItem) {
            WearableItem wearable = (WearableItem)item;
            return wearable.getWearableType();
        }
        return TYPE_BY_ITEM.get(item);
    }
}

