/*
 * Decompiled with CFR 0.152.
 */
package net.carlo.or_lib_mod.wearable;

import java.util.ArrayList;
import java.util.List;
import net.carlo.or_lib_mod.wearable.WearableAttributeModifierData;
import net.minecraft.class_1322;
import net.minecraft.class_2960;

public class WearableProperties {
    private final String defaultTrinketSlot;
    private final List<WearableAttributeModifierData> modifiers;

    public WearableProperties(String defaultTrinketSlot, List<WearableAttributeModifierData> modifiers) {
        this.defaultTrinketSlot = defaultTrinketSlot;
        this.modifiers = List.copyOf(modifiers);
    }

    public String getDefaultTrinketSlot() {
        return this.defaultTrinketSlot;
    }

    public List<WearableAttributeModifierData> getModifiers() {
        return this.modifiers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String defaultTrinketSlot;
        private final List<WearableAttributeModifierData> modifiers = new ArrayList<WearableAttributeModifierData>();

        public Builder defaultTrinketSlot(String slot) {
            this.defaultTrinketSlot = slot;
            return this;
        }

        public Builder addAttribute(class_2960 attributeId, double amount, class_1322.class_1323 operation) {
            this.modifiers.add(new WearableAttributeModifierData(attributeId, amount, operation));
            return this;
        }

        public WearableProperties build() {
            return new WearableProperties(this.defaultTrinketSlot, List.copyOf(this.modifiers));
        }
    }
}

