/*
 * Decompiled with CFR 0.152.
 */
package net.carlo.or_lib_mod.client.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_809;

public final class HeldModelOverrideRegistry {
    private static final Map<class_1792, Override> OVERRIDES = new IdentityHashMap<class_1792, Override>();

    private HeldModelOverrideRegistry() {
    }

    public static void register(class_1792 item, Override override) {
        Objects.requireNonNull(item, "item");
        Objects.requireNonNull(override, "override");
        OVERRIDES.put(item, override);
    }

    public static Override get(class_1792 item) {
        return OVERRIDES.get(item);
    }

    public static Collection<class_1091> getAllModelIds() {
        ArrayList<class_1091> ids = new ArrayList<class_1091>(OVERRIDES.size());
        for (Override override : OVERRIDES.values()) {
            ids.add(override.modelId());
        }
        return ids;
    }

    public static Override headOnly(class_1091 modelId) {
        EnumSet<class_809.class_811> modes = EnumSet.of(class_809.class_811.field_4316);
        return new Override(modelId, modes);
    }

    public static Override allButGroundAndFixed(class_1091 modelId) {
        EnumSet<class_809.class_811> modes = EnumSet.allOf(class_809.class_811.class);
        modes.remove(class_809.class_811.field_4318);
        modes.remove(class_809.class_811.field_4319);
        return new Override(modelId, modes);
    }

    public static final class Override {
        private final class_1091 modelId;
        private final EnumSet<class_809.class_811> modes;

        public Override(class_1091 modelId, EnumSet<class_809.class_811> modes) {
            this.modelId = Objects.requireNonNull(modelId, "modelId");
            this.modes = Objects.requireNonNull(modes, "modes");
        }

        public class_1091 modelId() {
            return this.modelId;
        }

        public EnumSet<class_809.class_811> modes() {
            return this.modes;
        }

        public boolean appliesTo(class_809.class_811 mode) {
            return this.modes.contains(mode);
        }
    }
}

