/*
 * Decompiled with CFR 0.152.
 */
package net.carlo.or_lib_mod.wearable;

import dev.emi.trinkets.api.SlotReference;
import net.carlo.or_lib_mod.wearable.WearableType;

public final class WearableSlotRestrictions {
    private WearableSlotRestrictions() {
    }

    public static boolean isAllowed(WearableType type, SlotReference slotReference) {
        if (type == null || slotReference == null) {
            return false;
        }
        String group = slotReference.inventory().getSlotType().getGroup();
        String name = slotReference.inventory().getSlotType().getName();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case WearableType.RING -> {
                if ("hand".equals(group) || "offhand".equals(group) || "ring".equals(name)) {
                    yield true;
                }
                yield false;
            }
            case WearableType.BRACELET -> {
                if ("hand".equals(group) || "offhand".equals(group) || "bracelet".equals(name)) {
                    yield true;
                }
                yield false;
            }
            case WearableType.NECKLACE -> {
                if ("chest".equals(group) || "necklace".equals(name)) {
                    yield true;
                }
                yield false;
            }
            case WearableType.BELT -> {
                if ("chest".equals(group) || "belt".equals(name) || "legs".equals(group)) {
                    yield true;
                }
                yield false;
            }
            case WearableType.ANKLET -> {
                if ("feet".equals(group) || "anklet".equals(name)) {
                    yield true;
                }
                yield false;
            }
            case WearableType.EARRING -> {
                if ("head".equals(group) || "ear".equals(name)) {
                    yield true;
                }
                yield false;
            }
            case WearableType.CROWN -> "head".equals(group) || "crown".equals(name);
        };
    }
}

