# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project *loosely* adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).
The main difference is that the MAJOR.MINOR.PATCH system doesn't change the MAJOR indicator, as most version changes are NOT backwards compatible and the MINOR indicator will increase regardless of if that version can be played in an earlier update.
However, if the version update is a bug fix/patch/update that does NOT change the resourcepack or datapack format, and does NOT otherwise add anything, then the PATCH indicator will be updated accordingly.
TL;DR: This pretty much follows Mojang's update structure for Minecraft updates.

Anything noted as (Undocumented) is because I didn't write down the change at that time and can't remember what was added/removed/edited. Sorry.

Update numbers are written in YYYY/MM/DD format.

## [1.2.4] - 2025-09-19

### Fixes
Ported the following fixes from later versions:
- [RMF-44](https://github.com/regfunkid/reg-more-foods/issues/44): Pasta doesn't stack
- [RMF-46](https://github.com/regfunkid/reg-more-foods/issues/46): Using Raspberries to craft Smoothies makes Blackberry Smoothies instead
- [RMF-47](https://github.com/regfunkid/reg-more-foods/issues/47): Item names are only supported for the "English US" language pack, and not for any other english varients
- [RMF-48](https://github.com/regfunkid/reg-more-foods/issues/48): Items pictures aren't working
- [RMF-49](https://github.com/regfunkid/reg-more-foods/issues/49): Rabbits always drop a Rabbit's Foot when killed
- [RMF-50](https://github.com/regfunkid/reg-more-foods/issues/50): The "Hey, That's Ours!" advancement cannot be completed
- [RMF-51](https://github.com/regfunkid/reg-more-foods/issues/51): The `set_grinding_speed` config command doesn't actually 
- [RMF-57](https://github.com/regfunkid/reg-more-foods/issues/57): Entity Loot Table Modified
- [RMF-61](https://github.com/regfunkid/reg-more-foods/issues/61): Loot table for `potatoes` has incorrect component definition