# Because players technically "join" the server *after* the server/world loads the datapack, the following commands never set the scores on players. Thus, this setup function is delayed by a full 20 seconds to ensure all commands inside run as intended
# These scoreboard commands set the scores necessary to utilize things like the Mortar & Pestle, Shaker Cup, etc. For players joining the world *after* the setup, there is a failsafe that updates the rmf.grindingCooldown and rmf.shakerCooldown scores when the player obtains the items that require those scores. The other scores are fine to update on their own and don't need failsafes
scoreboard players set @a rmf.grindingCooldown 0
scoreboard players set @a rmf.shakerCooldown 0
scoreboard players set @a rmf.roastingProgress 0
scoreboard players set @a rmf.recycle_bones 0
scoreboard players set @a rmf.mined_wheat 0
scoreboard players set @a rmf.mined_beetroots 0
# Send a nice message to all players currently online, briefly explaining what to do
function rmf:bg/welcome_message
#
# Since we know this is the first time RMF is being loaded on the world, let players know what's new to this version
# Then, update the rmf.version scoreboard
function rmf:bg/whats_new
scoreboard players set rmf.config rmf.version 124
#
# Once absolutely all commands and functions have been run sucessfully, we can now tell the datapack that the world has been loaded successfully and to update the scoreboard.
# This will only update if the world has never been loaded before in Reg's More Foods--in other words, if this is the first time it's been installed in world
# By the time this command runs, the load function will have already finished all its commands. Since we already know that rmf.worldLoaded is 0 (because otherwise how else would this function run to begin with?) we don't need to check for it here. We can just run the scoreboard safely
scoreboard players set rmf.config rmf.worldLoaded 1