# This function runs every time the pack is either loaded into a world, or reloaded using /reload.
# First things first: we need to create some new objectives (variables) to store important info we'll be using later. Some of these are self explanatory just from their names
scoreboard objectives add rmf.daytime dummy
scoreboard objectives add rmf.enableTimeTracking dummy
scoreboard objectives add rmf.grindingCooldown dummy
scoreboard objectives add rmf.grindingMaxCooldown dummy
scoreboard objectives add rmf.shakerCooldown dummy
scoreboard objectives add rmf.mined_cactus mined:cactus
scoreboard objectives add rmf.ate_cake minecraft.custom:minecraft.eat_cake_slice
scoreboard objectives add rmf.roastingProgress dummy
scoreboard objectives add rmf.recycle_bones dummy
scoreboard objectives add rmf.mined_wheat mined:wheat
scoreboard objectives add rmf.mined_beetroots mined:beetroots
scoreboard objectives add rmf.version dummy
scoreboard objectives add rmf.worldLoaded dummy
#
# Then, we need to set the values for two of the variables we just created--but only if this is the FIRST TIME the datapack is being loaded
# rmf.enableTimeTracking enables the Clock displaying the current daytime in 12 hour format if its held when the player is crouching
# rmf.grindingMaxCooldown sets the speed of the Mortar & Pestle when it's used to grind an item
# Both of these settings can be changed by a server op/admin using commands, but these are the default settings
execute unless score rmf.config rmf.worldLoaded matches 1 run scoreboard players set rmf.config rmf.enableTimeTracking 1
execute unless score rmf.config rmf.worldLoaded matches 1 run scoreboard players set rmf.config rmf.grindingMaxCooldown 20
# 
# This next command is one of two that tell the datapack whether this is the FIRST TIME Reg's More Foods is being loaded on this specific world--this is important for future updates and setting things up so they don't break later
# It first checks if the rmf.worldLoaded score is 1 (which would be impossible if it IS the first time the datapack is loaded): if it isn't 1, it will set it to "0"
# In a background setup function, this same command is present, except it's checking if rmf.worldLoaded is set to 0: if it is, it will set it to "1", confirming the world has been loaded
execute unless score rmf.config rmf.worldLoaded matches 1 run scoreboard players set rmf.config rmf.worldLoaded 0
# ^ i don't know what will happen during datapack load if this value is manually changed so please don't do that
#
# Lastly, since the datapack is preparing to update the rmf.worldLoaded score, we can now run the setup function. 
# The setup function contains commands which affect the player's scores directly--however, the load function triggers *before* the player connects to the server, meaning they won't apply correctly. To ensure they all get loaded, the setup function is scheduled
# This setup function is set to trigger 20 seconds after the load function, to account for players with slower computers (cough cough mine)
# Also, inform the player that the datapack is setting things up and to wait for a moment (if the player connects to the world fast enough to even see the message). Informing the player also helps make the player feel like the setup is shorter than it actually is. :)
execute unless score rmf.config rmf.worldLoaded matches 1 run schedule function rmf:bg/setup_notify 10s append
execute unless score rmf.config rmf.worldLoaded matches 1 run schedule function rmf:bg/setup 20s append
#
# In the event that a player has updated the datapack, and the rmf.worldLoaded score has already been updated, update the datapack on reload instead of setting it up (detect this change through the rmf.version scoreboard value of the LAST version)
execute if score rmf.config rmf.version matches 122 run schedule function rmf:bg/update_notify 10s append
execute if score rmf.config rmf.version matches 122 run schedule function rmf:bg/update 20s append
# Once the pack has finished loading, play a nice sound (setup function is not required to play the sound)
execute as @a at @s run playsound minecraft:block.note_block.bell master @s ~ ~ ~
# If the player has the Yet Another Data Pack API data pack installed, give them an advancement
# (The Yet Another Datapack API hasn't been created yet, but an advancement will be here when it is!)