package dev.kleinbox.startklar;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

@SuppressWarnings("UnstableApiUsage")
public class Startklar implements ModInitializer {
	public static final String MOD_ID = "startklar";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final Config CONFIG = Config.createToml(FabricLoader.getInstance().getConfigDir(), MOD_ID,
            "server", Config.class);

    /**
     * 0 = NO FLYING
     * 1 = ALLOW FLYING
     * 2 = ALLOW FLYING WITH BOOST
     */
    public static final AttachmentType<Integer> FLYING_SINCE_SPAWN_TYPE = AttachmentRegistry.createDefaulted(
            Startklar.of("player_extended_data"),
            () -> 0
    );

    @Override
    public void onInitialize() {
        // Elytra start event
        ServerTickEvents.END_WORLD_TICK.register(Startklar::startFlying);

        // Elytra - Allow keep flying
        EntityElytraEvents.CUSTOM.register(Startklar::keepFlying);

        // Flying boost & status indicator
        if (CONFIG.flightDuration > 0) {
            class_1799 flightDuration = class_1802.field_8639.method_7854();
            flightDuration.method_57379(class_9334.field_49616, new class_9284(CONFIG.flightDuration, List.of()));

            ServerTickEvents.END_WORLD_TICK.register((level) -> flyingBoost(level, flightDuration));
        }

        // Cancel fall damage after flying
        ServerLivingEntityEvents.ALLOW_DAMAGE.register(Startklar::cancelDamageUponLanding);

        LOGGER.info("Wir sind startklar!");
    }

    /**
     * Allows players near spawn to start flying upon call.
     */
    private static void startFlying(class_3218 level) {
        if (level.method_27983() != class_1937.field_25179 || level.method_8608())
            return;

        int diameter = CONFIG.spawnDiameter;
        class_243 posSpawn = level.method_74854().comp_4915().comp_2208().method_46558();
        class_238 spawnBoundingBox = class_238.method_30048(posSpawn, diameter, diameter, diameter);

        List<class_1657> entities = level.method_18467(class_1657.class, spawnBoundingBox);

        entities.forEach((player) -> {
            int isFlyingSinceSpawn = player.getAttachedOrElse(FLYING_SINCE_SPAWN_TYPE, 0);

            if (player.field_6017 > CONFIG.toggleAfterFallDistanceOf && isFlyingSinceSpawn <= 0) {
                player.setAttached(FLYING_SINCE_SPAWN_TYPE, 2);
                player.method_23669();
                Startklar.LOGGER.debug("Added FLYING_SINCE_SPAWN tag for {}", player.method_5667());
            }
        });
    }

    /**
     * Determines whenever a player is allowed to keep flying without an Elytra outside spawn.
     * @see EntityElytraEvents.Custom
     */
    private static boolean keepFlying(class_1309 entity, boolean tickElytra) {
        if (!(entity instanceof class_1657) || entity.method_73183().method_8608())
            return false;

        int isFlyingSinceSpawn = entity.getAttachedOrElse(FLYING_SINCE_SPAWN_TYPE, 0);
        return isFlyingSinceSpawn >= 1;
    }

    /**
     * Determines whenever a player should take fall damage / fly-into-wall damage.
     * @see ServerLivingEntityEvents.AllowDamage
     */
    private static boolean cancelDamageUponLanding(class_1309 entity, class_1282 source, float amount) {
        class_1937 level = entity.method_73183();

        if (!(entity instanceof class_1657))
            return true;

        int isFlyingSinceSpawn = entity.getAttachedOrElse(FLYING_SINCE_SPAWN_TYPE, 0);

        boolean allowDamage = !(isFlyingSinceSpawn > 0)
                || (source != level.method_48963().method_48827() && source != level.method_48963().method_48828());

        Startklar.LOGGER.debug("Allowing damage: {} for {}", allowDamage, entity.method_5667());
        return allowDamage;
    }

    /**
     * Allows players to perform a boost while flying upon call.
     */
    private static void flyingBoost(class_3218 level, class_1799 flightDuration) {
        level.method_18456().forEach((player) -> {
            int isFlyingSinceSpawn = player.getAttachedOrElse(FLYING_SINCE_SPAWN_TYPE, 0);

            if (isFlyingSinceSpawn < 2)
                return;

            // status indicator here
            player.method_7353(class_2561.method_43470(CONFIG.boostIndicator).method_27692(class_124.field_1076),
                    true);

            if (player.method_5715()) {
                class_1676.method_61551(new class_1671(level, flightDuration, player), level, flightDuration);

                player.setAttached(FLYING_SINCE_SPAWN_TYPE, 1);
                Startklar.LOGGER.debug("Giving {} a boost", player.method_5667());
            }
        });
    }

    @SuppressWarnings("SameParameterValue")
    private static class_2960 of(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }
}