package dev.kleinbox.startklar.mixin;

import dev.kleinbox.startklar.Startklar;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_5712;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static dev.kleinbox.startklar.Startklar.FLYING_SINCE_SPAWN_TYPE;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    /**
     * After landing, ensure the player cannot fly again outside the spawn.
     */
    @SuppressWarnings("UnstableApiUsage")
    @Override
    public void method_38785() {
        boolean value = super.method_24828();
        int isFlyingSinceSpawn = this.getAttachedOrElse(FLYING_SINCE_SPAWN_TYPE, 0);

        if ((isFlyingSinceSpawn > 0) && value) {
            this.removeAttached(FLYING_SINCE_SPAWN_TYPE);
            Startklar.LOGGER.debug("Removed FLYING_SINCE_SPAWN tag for {}", this.method_5667());
        }


        super.method_38785();
    }

    /**
     * Cancels the code responsible for damaging the Elytra, as the server would otherwise crash, since the player
     * likely will not wear any Elytra's.
     */
    @Inject(
            method = "updateFallFlying",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/Util;getRandom(Ljava/util/List;Lnet/minecraft/util/RandomSource;)Ljava/lang/Object;",
                    ordinal = 0
            ),
            cancellable = true
    )
    private void startklar$skipElytraDurability(CallbackInfo ci) {
        if (isEntityFlying()) {
            ci.cancel();
            this.method_32876(class_5712.field_28158); // Since we skip this by canceling here
        }
    }

    @SuppressWarnings("UnstableApiUsage")
    @Unique
    private boolean isEntityFlying() {
        int isFlyingSinceSpawn = this.getAttachedOrElse(FLYING_SINCE_SPAWN_TYPE, 0);
        return isFlyingSinceSpawn > 0;
    }
}