/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.impl.aqua.AquaticAlienEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.AlienEggEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.ChestbursterEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.ClassicAlienEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import mods.cybercat.gigeresque.common.entity.impl.hellmorphs.BaphomorphEntity;
import mods.cybercat.gigeresque.common.entity.impl.hellmorphs.HellbursterEntity;
import mods.cybercat.gigeresque.common.entity.impl.hellmorphs.HellmorphRunnerEntity;
import mods.cybercat.gigeresque.common.entity.impl.misc.SpitterEntity;
import mods.cybercat.gigeresque.common.entity.impl.mutant.HammerpedeEntity;
import mods.cybercat.gigeresque.common.entity.impl.mutant.PopperEntity;
import mods.cybercat.gigeresque.common.entity.impl.mutant.StalkerEntity;
import mods.cybercat.gigeresque.common.entity.impl.neo.NeobursterEntity;
import mods.cybercat.gigeresque.common.entity.impl.neo.NeomorphAdolescentEntity;
import mods.cybercat.gigeresque.common.entity.impl.neo.NeomorphEntity;
import mods.cybercat.gigeresque.common.entity.impl.runner.RunnerAlienEntity;
import mods.cybercat.gigeresque.common.entity.impl.runner.RunnerbursterEntity;
import mods.cybercat.gigeresque.common.entity.impl.templebeast.DraconicTempleBeastEntity;
import mods.cybercat.gigeresque.common.entity.impl.templebeast.MoonlightHorrorTempleBeastEntity;
import mods.cybercat.gigeresque.common.entity.impl.templebeast.RavenousTempleBeastEntity;
import mods.cybercat.gigeresque.common.item.GigItems;
import mods.cybercat.gigeresque.common.worlddata.PandoraData;
import mods.cybercat.gigeresque.common.worlddata.PandoraEffect;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@Mod(value="gigeresque")
public final class NeoForgeMod {
    public static DeferredRegister<BlockEntityType<?>> blockEntityTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"gigeresque");
    public static DeferredRegister<Block> blockDeferredRegister = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"gigeresque");
    public static DeferredRegister<EntityType<?>> entityTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"gigeresque");
    public static DeferredRegister<Item> itemDeferredRegister = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"gigeresque");
    public static DeferredRegister<SoundEvent> soundEventDeferredRegister = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"gigeresque");
    public static DeferredRegister<StructureType<?>> structureTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"gigeresque");
    public static DeferredRegister<ParticleType<?>> particleTypeDeferredRegister = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"gigeresque");
    public static DeferredRegister<CreativeModeTab> creativeModeTabDeferredRegister = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"gigeresque");
    public static DeferredRegister<MobEffect> statusEffectDeferredRegister = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"gigeresque");
    public static DeferredRegister<Fluid> fluidDeferredRegister = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"gigeresque");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"gigeresque");
    private final PandoraEffect pandoraEffect = new PandoraEffect();
    public static final Supplier<FluidType> BLACKFLUID_TYPE = FLUID_TYPES.register("black_fluid_type", () -> new FluidType(FluidType.Properties.create().descriptionId("block.gigeresque.black_fuild_block").canSwim(false).canDrown(false).pathType(PathType.LAVA).adjacentPathType(null).sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_EMPTY).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).lightLevel(15).density(3000).viscosity(6000)){

        public boolean canConvertToSource(@NotNull FluidState state, @NotNull LevelReader reader, @NotNull BlockPos pos) {
            if (reader instanceof Level) {
                Level level = (Level)reader;
                return level.getGameRules().getBoolean(GameRules.RULE_WATER_SOURCE_CONVERSION);
            }
            return super.canConvertToSource(state, reader, pos);
        }

        public double motionScale(@NotNull Entity entity) {
            return 0.0023333333333333335;
        }

        public void setItemMovement(@NotNull ItemEntity entity) {
            Vec3 vec3 = entity.getDeltaMovement();
            entity.setDeltaMovement(vec3.x * (double)0.95f, vec3.y + (double)(vec3.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3.z * (double)0.95f);
        }
    });

    public NeoForgeMod(IEventBus modEventBus) {
        CommonMod.initRegistries();
        blockEntityTypeDeferredRegister.register(modEventBus);
        blockDeferredRegister.register(modEventBus);
        entityTypeDeferredRegister.register(modEventBus);
        itemDeferredRegister.register(modEventBus);
        soundEventDeferredRegister.register(modEventBus);
        structureTypeDeferredRegister.register(modEventBus);
        particleTypeDeferredRegister.register(modEventBus);
        creativeModeTabDeferredRegister.register(modEventBus);
        statusEffectDeferredRegister.register(modEventBus);
        fluidDeferredRegister.register(modEventBus);
        modEventBus.addListener(this::createEntityAttributes);
        modEventBus.addListener(this::onRegisterEvent);
        ModEntitySpawn.SERIALIZER.register(modEventBus);
        FLUID_TYPES.register(modEventBus);
        if (CommonMod.config.enablePandoraEffects) {
            NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onWorldEndTick);
            NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, this::onWorldTick);
        }
        NeoForge.EVENT_BUS.addListener(this::onJoin);
        modEventBus.addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        AzIdentityRegistry.register((Item)GigItems.TRACKER.get(), (Item[])new Item[0]);
    }

    public void onRegisterEvent(RegisterSpawnPlacementsEvent event) {
        event.register(GigEntities.EGG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, AlienEntity::checkMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }

    public void createEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(GigEntities.ALIEN.get(), ClassicAlienEntity.createAttributes().build());
        event.put(GigEntities.AQUATIC_ALIEN.get(), AquaticAlienEntity.createAttributes().build());
        event.put(GigEntities.AQUATIC_CHESTBURSTER.get(), ChestbursterEntity.createAttributes().build());
        event.put(GigEntities.CHESTBURSTER.get(), ChestbursterEntity.createAttributes().build());
        event.put(GigEntities.EGG.get(), AlienEggEntity.createAttributes().build());
        event.put(GigEntities.FACEHUGGER.get(), FacehuggerEntity.createAttributes().build());
        event.put(GigEntities.RUNNER_ALIEN.get(), RunnerAlienEntity.createAttributes().build());
        event.put(GigEntities.RUNNERBURSTER.get(), RunnerbursterEntity.createAttributes().build());
        event.put(GigEntities.MUTANT_POPPER.get(), PopperEntity.createAttributes().build());
        event.put(GigEntities.MUTANT_HAMMERPEDE.get(), HammerpedeEntity.createAttributes().build());
        event.put(GigEntities.MUTANT_STALKER.get(), StalkerEntity.createAttributes().build());
        event.put(GigEntities.NEOBURSTER.get(), NeobursterEntity.createAttributes().build());
        event.put(GigEntities.NEOMORPH_ADOLESCENT.get(), NeomorphAdolescentEntity.createAttributes().build());
        event.put(GigEntities.NEOMORPH.get(), NeomorphEntity.createAttributes().build());
        event.put(GigEntities.SPITTER.get(), SpitterEntity.createAttributes().build());
        event.put(GigEntities.DRACONICTEMPLEBEAST.get(), DraconicTempleBeastEntity.createAttributes().build());
        event.put(GigEntities.RAVENOUSTEMPLEBEAST.get(), RavenousTempleBeastEntity.createAttributes().build());
        event.put(GigEntities.MOONLIGHTHORRORTEMPLEBEAST.get(), MoonlightHorrorTempleBeastEntity.createAttributes().build());
        event.put(GigEntities.HELLMORPH_RUNNER.get(), HellmorphRunnerEntity.createAttributes().build());
        event.put(GigEntities.BAPHOMORPH.get(), BaphomorphEntity.createAttributes().build());
        event.put(GigEntities.HELL_BURSTER.get(), HellbursterEntity.createAttributes().build());
    }

    public void onWorldTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.getLevel();
        this.pandoraEffect.tick(serverLevel, serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING), true);
    }

    public void onWorldEndTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        boolean hasAdvancement = false;
        for (Player player : event.getLevel().players()) {
            ServerPlayer serverPlayer;
            AdvancementHolder advancement;
            if (!(player instanceof ServerPlayer) || (advancement = (serverPlayer = (ServerPlayer)player).getServer().getAdvancements().get(Constants.modResource("xeno_dungeon"))) == null || !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) continue;
            hasAdvancement = true;
            break;
        }
        if (hasAdvancement) {
            PandoraData.setIsTriggered(true);
        }
    }

    private void onJoin(ClientPlayerNetworkEvent.LoggingIn event) {
        Constants.particleCount = 0;
    }

    record ModEntitySpawn(HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        public static DeferredRegister<MapCodec<? extends BiomeModifier>> SERIALIZER = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"gigeresque");
        static Supplier<MapCodec<ModEntitySpawn>> JARJAR_SPAWN_CODEC = SERIALIZER.register("mobspawns", () -> RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ModEntitySpawn::biomes), (App)MobSpawnSettings.SpawnerData.CODEC.fieldOf("spawn").forGetter(ModEntitySpawn::spawn)).apply((Applicative)builder, ModEntitySpawn::new)));

        public void modify(@NotNull Holder<Biome> biome, @NotNull BiomeModifier.Phase phase, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.contains(biome)) {
                builder.getMobSpawnSettings().addSpawn(MobCategory.MONSTER, this.spawn);
            }
        }

        @NotNull
        public MapCodec<? extends BiomeModifier> codec() {
            return JARJAR_SPAWN_CODEC.get();
        }
    }
}

