/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mods.cybercat.gigeresque.client.entity.render.helper.EntityHeadData;
import mods.cybercat.gigeresque.client.entity.render.helper.EntityHeadOffsetData;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class FacehuggerModelRenderer
extends AzEntityModelRenderer<FacehuggerEntity> {
    public FacehuggerModelRenderer(AzEntityRendererPipeline<FacehuggerEntity> entityRendererPipeline, AzLayerRenderer<FacehuggerEntity> layerRenderer) {
        super(entityRendererPipeline, layerRenderer);
    }

    protected void applyRotations(FacehuggerEntity animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (!animatable.isPassenger()) {
            super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
            return;
        }
        LivingEntity host = (LivingEntity)animatable.getVehicle();
        if (host == null) {
            return;
        }
        EntityHeadData data = EntityHeadData.ENTITY_HEAD_DATA_BY_TYPE.get(host.getType());
        if (data == null) {
            return;
        }
        this.applyFaceRotations(animatable, poseStack, partialTick, host, data);
    }

    private void applyFaceRotations(FacehuggerEntity facehuggerEntity, PoseStack poseStack, float partialTick, LivingEntity host, EntityHeadData data) {
        float bodyYaw = Mth.rotLerp((float)partialTick, (float)host.yBodyRotO, (float)host.yBodyRot);
        float headYaw = Mth.rotLerp((float)partialTick, (float)host.yHeadRotO, (float)host.yHeadRot) - bodyYaw;
        float headPitch = Mth.rotLerp((float)partialTick, (float)host.getXRot(), (float)host.xRotO);
        double xPivot = data.pivot().x;
        double yPivot = data.pivot().y;
        double zPivot = data.pivot().z;
        double ySize = data.size().y;
        double zSize = data.size().z;
        poseStack.mulPose(Axis.YN.rotationDegrees(bodyYaw));
        poseStack.translate(xPivot, yPivot - (double)host.getBbHeight(), -zPivot);
        poseStack.mulPose(Axis.YN.rotationDegrees(headYaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(headPitch));
        poseStack.translate(-xPivot, -yPivot + (double)host.getBbHeight(), zPivot);
        EntityHeadOffsetData offsetSuppilers = EntityHeadOffsetData.ENTITY_HEAD_OFFSET_DATA_BY_TYPE.get(host.getType());
        if (offsetSuppilers != null) {
            Double yOffset = offsetSuppilers.verticalOffsetSupplier().apply(data, (Entity)facehuggerEntity);
            Double zOffset = offsetSuppilers.faceOffsetSupplier().apply(data, (Entity)facehuggerEntity);
            poseStack.translate(0.0, yOffset.doubleValue(), zOffset.doubleValue());
        } else {
            poseStack.translate(0.0, -ySize, zSize);
        }
    }
}

