/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.classic;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mods.cybercat.gigeresque.client.entity.model.ClassicModelRenderer;
import mods.cybercat.gigeresque.client.entity.model.EntityModels;
import mods.cybercat.gigeresque.client.entity.render.feature.ClassicAgingOverLay;
import mods.cybercat.gigeresque.client.entity.texture.EntityTextures;
import mods.cybercat.gigeresque.common.entity.animators.classic.ClassicAlienAnimator;
import mods.cybercat.gigeresque.common.entity.helper.managers.animations.classic.ClassicAlienAnimManager;
import mods.cybercat.gigeresque.common.entity.impl.classic.ClassicAlienEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class AlienEntityRenderer
extends AzEntityRenderer<ClassicAlienEntity> {
    public AlienEntityRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder($ -> EntityModels.ALIEN, xeno -> {
            if (xeno.stasisManager.isStasis()) {
                return EntityTextures.ALIEN_STASIS;
            }
            return EntityTextures.ALIEN;
        }).setAnimatorProvider(ClassicAlienAnimator::new).setDeathMaxRotation(0.0f).setShadowRadius(0.5f).setScale(classicAlienEntity -> Float.valueOf(Math.clamp(0.8f + classicAlienEntity.getGrowth() / classicAlienEntity.getMaxGrowth() / 5.0f, 0.0f, 1.0f))).addRenderLayer(new ClassicAgingOverLay(EntityTextures.ALIEN_YOUNG)).setScale(classicAlienEntity -> {
            float scaleFactor = 0.8f + classicAlienEntity.getGrowth() / classicAlienEntity.getMaxGrowth() / 5.0f;
            return Float.valueOf(Math.min(scaleFactor, 1.0f));
        }).build(), context);
    }

    public AzEntityRendererPipeline<ClassicAlienEntity> createPipeline(AzEntityRendererConfig<ClassicAlienEntity> config) {
        return new AzEntityRendererPipeline<ClassicAlienEntity>(this, config, (AzEntityRenderer)this){

            protected AzModelRenderer<ClassicAlienEntity> createModelRenderer(AzLayerRenderer<ClassicAlienEntity> layerRenderer) {
                return new ClassicModelRenderer(this, layerRenderer);
            }
        };
    }

    public void render(@NotNull ClassicAlienEntity entity, float entityYaw, float partialTick, @NotNull PoseStack stack, @NotNull MultiBufferSource bufferSource, int packedLightIn) {
        ClassicAlienAnimManager.handleAnimations(entity);
        super.render((Entity)entity, entityYaw, partialTick, stack, bufferSource, packedLightIn);
    }
}

