/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.feature;

import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mods.cybercat.gigeresque.client.entity.texture.EntityTextures;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class BloodLayer<T extends AlienEntity>
implements AzRenderLayer<T> {
    public void preRender(AzRendererPipelineContext<T> context) {
    }

    public void render(AzRendererPipelineContext<T> context) {
        AlienEntity animatable = (AlienEntity)context.animatable();
        AzRendererPipeline renderPipeline = context.rendererPipeline();
        RenderType rendertype = RenderType.entityTranslucentCull((ResourceLocation)EntityTextures.CHESTBURSTER_BLOOD);
        float maxGrowth = animatable.getMaxGrowth() / 2.0f;
        if (animatable.getGrowth() < maxGrowth && animatable.isAlive()) {
            context.setRenderType(rendertype);
            context.setVertexConsumer(context.multiBufferSource().getBuffer(rendertype));
            float progress = (maxGrowth - animatable.getGrowth()) / maxGrowth;
            int alpha = (int)(progress * 255.0f) << 24;
            int color = context.renderColor() & 0xFFFFFF | alpha;
            context.setRenderColor(color);
            renderPipeline.reRender(context);
        }
    }

    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
    }
}

