/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.texture;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.InputStream;
import mods.cybercat.gigeresque.client.entity.texture.EntityTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class EggmorphLayerTexture
implements AutoCloseable {
    public RenderType renderLayer;
    private DynamicTexture texture = new DynamicTexture(new NativeImage(128, 128, true));

    public EggmorphLayerTexture(TextureManager textureManager, ResourceManager resourceManager, ResourceLocation base) {
        Minecraft.getInstance().execute(() -> {
            try {
                NativeImage baseImage = NativeImage.read((InputStream)resourceManager.getResourceOrThrow(base).open());
                NativeImage layerImage = NativeImage.read((InputStream)resourceManager.getResourceOrThrow(EntityTextures.EGGMORPH_OVERLAY).open());
                this.texture = new DynamicTexture(new NativeImage(layerImage.getWidth(), layerImage.getHeight(), true));
                int height = layerImage.getHeight();
                int width = layerImage.getWidth();
                float heightRatio = (float)height / (float)baseImage.getHeight();
                float widthRatio = (float)width / (float)baseImage.getWidth();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        NativeImage image;
                        int color = baseImage.getPixelRGBA((int)((float)x / widthRatio), (int)((float)y / heightRatio));
                        int alpha = color >> 24 & 0xFF;
                        if (alpha <= 25 || (image = this.texture.getPixels()) == null) continue;
                        image.setPixelRGBA(x, y, layerImage.getPixelRGBA(x, y));
                    }
                }
                this.texture.upload();
                baseImage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ResourceLocation id = textureManager.register("eggmorph_layer/" + base.getPath(), this.texture);
        this.renderLayer = RenderType.entityTranslucent((ResourceLocation)id);
    }

    @Override
    public void close() {
        this.texture.close();
    }
}

