/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

public class AcidParticle
extends TextureSheetParticle {
    protected final SpriteSet spriteProvider;
    protected boolean reachedGround;

    public AcidParticle(ClientLevel clientWorld, double d, double e, double f, double g, double h, double i, SpriteSet spriteProvider) {
        super(clientWorld, d, e, f);
        this.xd = g;
        this.yd = h;
        this.zd = i;
        float red = 0.627451f;
        float green = 0.61960787f;
        float blue = 0.03529412f;
        float colorRed = Mth.nextFloat((RandomSource)this.random, (float)(red - 0.05f), (float)(red + 0.05f));
        float colorGreen = Mth.nextFloat((RandomSource)this.random, (float)(green - 0.05f), (float)(green + 0.05f));
        float colorBlue = Mth.nextFloat((RandomSource)this.random, (float)(blue - 0.015f), (float)(blue + 0.015f));
        this.setColor(colorRed, colorGreen, colorBlue);
        this.gravity = 2.0E-4f;
        this.quadSize *= 0.75f;
        this.lifetime = (int)(10.0 / ((double)this.random.nextFloat() * 0.8 + 0.2));
        this.reachedGround = false;
        this.hasPhysics = true;
        this.spriteProvider = spriteProvider;
        this.setSpriteFromAge(spriteProvider);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && this.alpha > 0.0f) {
            this.xd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
            this.y -= 0.02;
        } else {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float tickDelta) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + tickDelta) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }
}

