/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.BlockBreakProgressManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FragileRoughBlock
extends Block
implements Fallable {
    private int standingTick = 0;

    public FragileRoughBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        double offsetX = random.nextDouble() - 0.5;
        double offsetY = 1.1 + random.nextDouble() * 1.3;
        double offsetZ = random.nextDouble() - 0.5;
        if ((level.getBlockState(pos.above()).isAir() || level.getBlockState(pos.above()).is(GigTags.ALLOW_MIST_BLOCKS)) && pos.getY() <= -50 && Constants.particleCount < 1500) {
            level.addParticle((ParticleOptions)GigParticles.MIST.get(), (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public void stepOn(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, Entity entity) {
        if (entity.getType().is(GigTags.GIG_ALIENS)) {
            return;
        }
        if (Constants.isCreativeSpecPlayer.test(entity)) {
            return;
        }
        super.stepOn(level, pos, state, entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (level instanceof ServerLevel) {
                ++this.standingTick;
                if (livingEntity.isSteppingCarefully() ? this.standingTick % 40 == 0 : this.standingTick % 10 == 0) {
                    BlockBreakProgressManager.damage(level, livingEntity.blockPosition().below(), this.standingTick);
                    level.playSound((Entity)livingEntity, pos, SoundEvents.TUFF_BRICKS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.standingTick = 0;
                }
            }
        }
    }
}

